/************************************************************************\

  File name: epsSetupApi.h
  Create by: Feitian Tech. Co., Ltd.
  
	[Copyright (C) 2003 Feitian Tech. Co., Ltd. All rights reserved.]
\************************************************************************/

#ifndef  __EPSSETUPAPI_40933B7E_AF1B_43A0_98E5_BF11FF0DA349_HEADER_FILE__
#define  __EPSSETUPAPI_40933B7E_AF1B_43A0_98E5_BF11FF0DA349_HEADER_FILE__

/************************************************************************/
/* Return value used by the deletefile notify callback function.
/************************************************************************/
#define NOTIFY_DELETEFILE_REBOOT	1
#define NOTIFY_DELETEFILE_RETRY		2
#define NOTIFY_DELETEFILE_CANCEL	3

/************************************************************************/
/* Return value used by the esa_IsHaveInstalled() function.
/************************************************************************/
#define ESA_NEVER_INSTALL					0
#define ESA_DEST_DVERSION_OLD				1
#define ESA_DEST_DVERSION_EQUAL				2
#define ESA_DEST_DVERSION_NEW				3

/************************************************************************/
/* Type define information
/************************************************************************/
typedef	DWORD (WINAPI *t_DeleteFileNotify)(char* fName);
typedef	void  (WINAPI* t_ShowMsgNotify)(char* sMsg);


/************************************************************************/
/* Callback functions define
/************************************************************************/

/************************************************************************/
/* Function name: esa_SetShowMsgNotifyCallback
/* 
/* Purpose:       Set a callback function to get the operation status.
/*					If set fNotify to NULL, this feathure be disabled.
/*
/* Parameter :		fNotify : A function pointer to t_MsgNotify.
/*
/* Return :			N/A
/************************************************************************/
void WINAPI esa_SetShowMsgNotifyCallback(t_ShowMsgNotify fNotify);

/************************************************************************/
/* Function name: esa_SetShowErrMsgNotifyCallback
/* 
/* Purpose:       Set a callback function to get the operation error.
/*					If set fNotify to NULL, this feathure be disabled.
/*
/* Parameter :		fNotify : A function pointer to t_MsgNotify.
/*
/* Return :			N/A
/************************************************************************/
void WINAPI esa_SetShowErrMsgNotifyCallback(t_ShowMsgNotify fNotify);

/************************************************************************/
/* Function name: esa_SetDeleteFileCallback
/* 
/* Purpose:       Set a callback function to get the delete status.
/*					If set fNotify to NULL, this feathure be disabled.
/*
/* Parameter :		fNotify : A function pointer to t_MsgNotify.
/*
/* Return :			N/A
/************************************************************************/
void WINAPI esa_SetDeleteFileCallback(t_DeleteFileNotify fNotify);


/************************************************************************/
/* Install functions define
/************************************************************************/

/************************************************************************/
/* Function name: esa_IsHaveInstalled
/*
/* Purpose:       Detect setup if has been installed on current system 
/*                before.
/*
/* Parameter:     N/A
/*
/* Return :			ESA_NEVER_INSTALL					0
/*                        current system has no installed ePass1000 before;
/*					ESA_DEST_DVERSION_OLD				1
/*                        current system ePass1000 version is old;
/*					ESA_DEST_DVERSION_EQUAL				2
/*                        current system ePass1000 version is equal the one
/*                        to be installed;
/*					ESA_DEST_DVERSION_NEW				3
/*                        current system ePass1000 version is new;
/************************************************************************/
int WINAPI esa_IsHaveInstalled(void);

/************************************************************************/
/* Function name: esa_DoInstall
/*
/* Purpose:       Setup main install function.
/*
/* Parameter:     /c2 = for install driver:
/*						Install two card device, you can see them in Device
/*                      Manager of Windows, if special /c3, then mean install
/*                      three card device and so on, if you install middleware,
/*						please do not use this parameter.
/*				  /a  = for install middleware:	 
/*						Active the monitor application after install,if no this
/*                      parameter, you have to active the ePass 1000 monitor manual,
/*                      if you install dirver, please do not use this parameter.
/*
/* Return :      false => failed
/*               true  => succeed
/*
/* Example:      esa_DoInstall("/c2")	[for install driver]
/*				 esa_DoInstall("/a")    [for install middleware]
/************************************************************************/
bool WINAPI esa_DoInstall(const char* szParam);

/************************************************************************/
/* Function name: esa_DoUninstall
/*
/* Purpose:       Setup main Uninstall function.
/*
/* Parameter:     (reserved)
/*
/* Return :      false => failed
/*               true  => succeed
/*
/* Example:      esa_DoUninstall("")
/************************************************************************/
bool WINAPI esa_DoUninstall(const char* szParam);

/************************************************************************/
/* Function name: esa_IsNeedReboot
/*
/* Purpose:       Detect setup if need reboot after install or uninstall.
/*
/* Parameter:     N/A
/*
/* Return :      false => No need
/*               true  => need
/************************************************************************/
bool WINAPI esa_IsNeedReboot();

#endif //__EPSSETUPAPI_40933B7E_AF1B_43A0_98xE5_BF11FF0DA349_HEADER_FILE__
