/*
[]=========================================================================[]

	Copyright(C) 1998-2004, Feitian Technologies Co., Ltd.
	All rights reserved.

FILE:
	CSPKeyTest.cpp

DESC:
	ePass2000 CSP Test, include key generation, encrypt and decrypt.

	Requirements: ePass2000 run-time package installed.

REVISION:
	2003-02-25 [Yubo]
		Created.
	[2004-08-02 Euphen Liu]
		Update for SSF33 alg.
[]=========================================================================[]
*/

#include "stdafx.h"
//test macro:

#define RC2TESTCHOISE				1
#define RC4TESTCHOISE				2
#define DESTESTCHOISE				3
#define DERIVERC4KEYTESTCHOISE		4
#define DERIVEDESKEYTESTCHOISE		5
#define RSACHOISE					6 

//CSP macro:
#define EPS1K 1
#define EPS2K 2
#define EPS2KPBOC 3
void ShowTitle(void)
{
		printf("===========================================================\n");
		printf("Please choise the test item:\n");
		printf("   0: EXIT\n");
		printf("   1: GENERATE RC2TEST\n");
		printf("   2: GENERATE RC4TEST\n");
		printf("   3: GENERATE DESTEST\n");
		printf("   4: DERIVE RC4 KEY\n");
		printf("   5: DERIVE DES KEY\n");
		printf("   6: RSA TEST\n");
		printf("===========================================================\n");
}

int main(void)
{
	bool bTest = 1;
	while(bTest)
	{
		ShowTitle();
		printf("Input test item: ");
		char Choise[32] = {0};
		cin >> Choise;
		int iChoise = atoi(Choise);

		printf("\n\n------------------------------------------------\n");
		if(iChoise==RC2TESTCHOISE)
		{
			SysKeyTest test;
			printf("RC2 test:\n");
			if(CSP_OK != test.TestKey(TEST_RC2_ALG))
			{
				printf("ERROR: Test RC2 key and key operation failed!\n\n");
				getch();
			}
			printf("RC2 test finish!\n");
			getch();
			bTest = 1;
		}
		else if(iChoise==RC4TESTCHOISE)
		{
			SysKeyTest test;
			printf("RC4 test:\n");
			if(CSP_OK != test.TestKey(TEST_RC4_ALG))
			{
				printf("ERROR: Test RC4 key and key operation failed!\n\n");
				getch();
			}
			printf("RC4 test finish!\n");
			getch();
			bTest = 1;
		}
		
		else if(iChoise == DESTESTCHOISE)
		{
			SysKeyTest test;
			printf("DES test:\n");
			if(CSP_OK != test.TestKey(TEST_DES_ALG))
			{
				printf("ERROR: Test DES key and key operation failed!\n\n");
				getch();
				//return CSP_FUNC_FAILED;
			}
			printf("Test DES key finish!\n");
			getch();
			bTest = 1;
		}
		
		else if(iChoise== DERIVERC4KEYTESTCHOISE)
		{
			DeriveKeyTest derkeytest;
			printf("Derive RC4 test:\n");
			if (CSP_OK != derkeytest.Testkey(TEST_RC4_ALG))
			{
				printf("ERROR: Test RC4 key and key operation failed!\n\n");
				getch();
			}
			printf("Test Derive RC4 key finish!\n");
			getch();
			bTest = 1;
		}

		else if(iChoise== DERIVEDESKEYTESTCHOISE)
		{
			DeriveKeyTest derkeytest;
			printf("Derive DES test:\n");
			if (CSP_OK != derkeytest.Testkey(TEST_DES_ALG))
			{
				printf("ERROR: Test DES key and key operation failed!\n\n");
				getch();
			}
			printf("Test derive des key finish!\n");
			getch();
			bTest = 1;
		}

		else if(iChoise== RSACHOISE)
		{
			CRSA rsaTest;
			printf("RSA test:\n");
			if (CSP_OK != rsaTest.TestRSA(EPS1K))
			{
				printf("ERROR: Test RSA key pair operation failed!\n\n");
				getch();
			}
			printf("Test RSA key pair finish!\n");
			getch();
			bTest = 1;
		}
		else
		{
			bTest = false;
			printf("\n\nPress any key to exit...\n");
			getch();
			return CSP_OK;
		}
		printf("------------------------------------------------\n\n");
	}
	return CSP_OK;
}
