/*
[]=================================================================[]
	eps1kUtility.h

	Copyright (C) 2001 Feitian Tech. Co. Ltd. All rights reserved.
	by Water Bird

	Comment : Some functions.
[]=================================================================[]
*/

#include "../../../include/epassapi.h"

// Try to find out an unused device and open it.
EPAS_STATUS OpenAnUnusedDevice(EPAS_HANDLE handle);

// FormatErrMsg() routine format an error status to a string
char* FormatErrMsg(EPAS_STATUS status);

// CheckOP() routine check out an operation
// If operation failed, show error message;
// If operation successful, show successful message.
int CheckOP(EPAS_STATUS status, char* Msg);

// ShowDeviceInfo() routine show the information of current
// opened device.
EPAS_STATUS ShowDeviceInfo(EPAS_HANDLE hePass);

// FormatFileTypeText() routine format the file type to a string.
char* FormatFileTypeText( unsigned char Type );

// FormatAccessText() routine format the access type to a string.
char* FormatAccessText( unsigned char access );

// FormatCapabilitesText() routine format the capabilites to a string.
char* FormatCapabilitesText(unsigned long ulCap);

// Show the data.
void ShowData(unsigned char* pData, unsigned long ulSize);

// Get user's input.
void GetUserInput(unsigned char* pBuf, unsigned long ulMaxSize);
