/*
[]======================================================================[]
	InitToken.h
	Copyright (C) 2002 Feitian Tech. Co., Ltd. All rights reserved.

	Comment :
		Interface to initialize ePass1000 for PKCS.

	History :
	[2002/10/31 Euphen Liu] Created.
	[2003/04/01 Euphen Liu] Update to use dllexport and dllimport.
[]======================================================================[]
*/

// Function
// eps1k_Initialize()
// 
// Initialize ePass1000 for PKCS/CSP.
// 
// You should set new SO PIN when initialize.
// If the szNewSOPIN is NULL, the old SO PIN would be kept.
// 
// Return value:
//    0 : Initialization operation sucessful.
//    nozero : There are some error happend.
#ifdef INITTOKEN_EXPORT
	__declspec( dllexport )
#else
	__declspec( dllimport )
#endif
unsigned long
__stdcall
eps1k_Initialize(
	const char* szOldSOPIN,				// [IN] The old SO PIN.
	const char* szNewSOPIN,				// [IN] The new SO PIN.
	const char* szUserPIN,				// [IN] The user PIN.
//	unsigned long dwPublicSize,			// [IN] Public data size in byte.
//	unsigned long dwPrivateSize,		// [IN] Private data size in byte.
	const char* szTokenName				// [IN] Token's friendly name.
	);