/***********************************************************************/
/*
/* epsSetup.cpp : A simple program that demo how to use parameter
/*                      to install ePass1000 driver and middleware.
/*
/* Create date:         03/18/2003.
/*
/* Create by:           Feitian Tech. Co., Ltd.
/*
/***********************************************************************/

#include "stdafx.h"
#include <conio.h>
//#include "epsSetupApi.h"

/************************************************************************/
/* Return value used by the deletefile notify callback function.
/************************************************************************/
#define NOTIFY_DELETEFILE_REBOOT	1
#define NOTIFY_DELETEFILE_RETRY		2
#define NOTIFY_DELETEFILE_CANCEL	3

/************************************************************************/
/* Return value used by the esa_IsHaveInstalled() function.
/************************************************************************/
#define ESA_NEVER_INSTALL					0
#define ESA_DEST_DVERSION_OLD				1
#define ESA_DEST_DVERSION_EQUAL				2
#define ESA_DEST_DVERSION_NEW				3

/************************************************************************/
/* install functions.
/************************************************************************/
typedef	void  (WINAPI* t_ShowMsgNotify)(char* sMsg);
typedef	DWORD (WINAPI *t_DeleteFileNotify)(char* fName);

typedef int (__stdcall* drv_IsHaveInstalled)(void);
drv_IsHaveInstalled esa_drv_IsHaveInstalled;
typedef bool (__stdcall* drv_DoInstall)(const char* szParam);
drv_DoInstall esa_drv_DoInstall;
typedef bool (__stdcall* drv_DoUninstall)(const char* szParam);
drv_DoUninstall esa_drv_DoUninstall;
typedef bool (__stdcall* drv_IsNeedReboot)();
drv_IsNeedReboot esa_drv_IsNeedReboot;
typedef void (__stdcall* drv_SetShowMsgNotifyCallback)(t_ShowMsgNotify fNotify);
drv_SetShowMsgNotifyCallback esa_drv_SetShowMsgNotifyCallback; 
typedef void (__stdcall* drv_SetShowErrMsgNotifyCallback)(t_ShowMsgNotify fNotify);
drv_SetShowErrMsgNotifyCallback esa_drv_SetShowErrMsgNotifyCallback;
typedef void (__stdcall* drv_SetDeleteFileCallback)(t_DeleteFileNotify fNotify);
drv_SetDeleteFileCallback esa_drv_SetDeleteFileCallback;

typedef int (__stdcall* mw_IsHaveInstalled)(void);
mw_IsHaveInstalled esa_mw_IsHaveInstalled;
typedef bool (__stdcall* mw_DoInstall)(const char* szParam);
mw_DoInstall esa_mw_DoInstall;
typedef bool (__stdcall* mw_DoUninstall)(const char* szParam);
mw_DoUninstall esa_mw_DoUninstall;
typedef bool (__stdcall* mw_IsNeedReboot)();
mw_IsNeedReboot esa_mw_IsNeedReboot;
typedef void (__stdcall* mw_SetShowMsgNotifyCallback)(t_ShowMsgNotify fNotify);
mw_SetShowMsgNotifyCallback esa_mw_SetShowMsgNotifyCallback;
typedef void (__stdcall* mw_SetShowErrMsgNotifyCallback)(t_ShowMsgNotify fNotify);
mw_SetShowErrMsgNotifyCallback esa_mw_SetShowErrMsgNotifyCallback;
typedef void (__stdcall* mw_SetDeleteFileCallback)(t_DeleteFileNotify fNotify);
mw_SetDeleteFileCallback esa_mw_SetDeleteFileCallback;

/***********************************************************************/
/* Callback Function which get ePass1000 driver and middleware setup operation status.
/* if you don't care the output infomation, you can ingore these.
/***********************************************************************/
DWORD	WINAPI MyDeleteProc(char* fName);
void	WINAPI MyProcessProc(char* sMsg);
void	WINAPI MyErrProc(char* sMsg);

int main(int argc, char* argv[])
{
	printf("/*************************************************************/\n");
	printf("         ePass 1000 driver and middleware setup demo!          \n");
	printf("/*************************************************************/\n");

	HMODULE hinst_drv_Lib;
	HMODULE hinst_mw_Lib;
	BOOL fFreeResult = FALSE; 
	hinst_drv_Lib = LoadLibrary( "ePsInst_drv.dll" );
	hinst_mw_Lib = LoadLibrary( "ePsInst_Mw.dll" );

    if((NULL!=hinst_drv_Lib)&&(NULL!=hinst_mw_Lib))
	{
	bool bSucc_drv = false;
	bool bSucc_mw = false;
	char ch;

	esa_drv_SetDeleteFileCallback=(drv_SetDeleteFileCallback)GetProcAddress(hinst_drv_Lib,"esa_SetDeleteFileCallback");
	esa_drv_SetDeleteFileCallback(MyDeleteProc);
	esa_drv_SetShowMsgNotifyCallback=(drv_SetShowMsgNotifyCallback)GetProcAddress(hinst_drv_Lib,"esa_SetShowMsgNotifyCallback");
	esa_drv_SetShowMsgNotifyCallback(MyProcessProc);
	esa_drv_SetShowErrMsgNotifyCallback=(drv_SetShowErrMsgNotifyCallback)GetProcAddress(hinst_drv_Lib,"esa_SetShowErrMsgNotifyCallback");
	esa_drv_SetShowErrMsgNotifyCallback(MyErrProc);


	esa_mw_SetDeleteFileCallback=(mw_SetDeleteFileCallback)GetProcAddress(hinst_mw_Lib,"esa_SetDeleteFileCallback");
	esa_mw_SetDeleteFileCallback(MyDeleteProc);
	esa_mw_SetShowMsgNotifyCallback=(mw_SetShowMsgNotifyCallback)GetProcAddress(hinst_mw_Lib,"esa_SetShowMsgNotifyCallback");
	esa_mw_SetShowMsgNotifyCallback(MyProcessProc);
	esa_mw_SetShowErrMsgNotifyCallback=(mw_SetShowErrMsgNotifyCallback)GetProcAddress(hinst_mw_Lib,"esa_SetShowErrMsgNotifyCallback");
	esa_mw_SetShowErrMsgNotifyCallback(MyErrProc);

	/***********************************************************************/
	/*  Step 1: first detect current system if has installed ePass1000 driver
	/*          and middleware before.
	/***********************************************************************/
	esa_drv_IsHaveInstalled=(drv_IsHaveInstalled)GetProcAddress(hinst_drv_Lib, "esa_IsHaveInstalled");
	int iRes_drv = esa_drv_IsHaveInstalled();

	esa_mw_IsHaveInstalled=(mw_IsHaveInstalled)GetProcAddress(hinst_mw_Lib, "esa_IsHaveInstalled");
	int iRes_mw = esa_mw_IsHaveInstalled();


	/************************************************************************/
	/* If the current system has installed ePass1000 driver before, and their
	/* versions are older, new or equal the one to be installed , then I select
	/* show "Reinstall" and "Uninstall", you can select case by youself, such
	/* as if iRes == ESA_DEST_DVERSION_NEW, you can just select Uninstall case
	/* to user.
	/************************************************************************/
	if(( iRes_drv == ESA_DEST_DVERSION_OLD   || 
		iRes_drv == ESA_DEST_DVERSION_EQUAL || 
		iRes_drv == ESA_DEST_DVERSION_NEW   )||
		( iRes_mw == ESA_DEST_DVERSION_OLD ))
	{
		printf("select 1 to Reinstall\n");
		printf("select 2 to Uninstall\n");
		ch = getchar();

		/***********************************************************************/
		/*  Step 2: If has installed before, user should can select reinstall or 
		/*          uninstall
		/*          and the "/c1" mean install 1 devices to system.
		/***********************************************************************/
		if(ch == '1')
		{
			esa_drv_DoInstall=(drv_DoInstall)GetProcAddress(hinst_drv_Lib, "esa_DoInstall");
			bSucc_drv = esa_drv_DoInstall("/c1");

			esa_mw_DoInstall=(mw_DoInstall)GetProcAddress(hinst_mw_Lib, "esa_DoInstall");
			bSucc_mw = esa_mw_DoInstall("/a");
		}
		else
		{
			esa_mw_DoUninstall=(mw_DoUninstall)GetProcAddress(hinst_mw_Lib, "esa_DoUninstall");
			bSucc_mw = esa_mw_DoUninstall("");

			esa_drv_DoUninstall=(drv_DoUninstall)GetProcAddress(hinst_drv_Lib, "esa_DoUninstall");
			bSucc_drv = esa_drv_DoUninstall("");

			
		}
	}	
	else
	{
		/***********************************************************************/
		/*  Step 3: If has NOT installed before, user should can Install.
		/*          and the "/c4" mean install 4 devices to system.
		/***********************************************************************/
		printf("select 1 to Install\n");	
		ch = getchar();

		if(ch == '1')
			{
			esa_drv_DoInstall=(drv_DoInstall)GetProcAddress(hinst_drv_Lib, "esa_DoInstall");
			bSucc_drv = esa_drv_DoInstall("/c1");

			esa_mw_DoInstall=(mw_DoInstall)GetProcAddress(hinst_mw_Lib, "esa_DoInstall");
			bSucc_mw = esa_mw_DoInstall("/a");
			}	
	}	

	/***********************************************************************/
	/*  Step 4: Output setup result and decide if need reboot.
	/***********************************************************************/
	printf("setup %s\n",(bSucc_drv&&bSucc_mw)?"success":"failed");

	esa_drv_IsNeedReboot=(drv_IsNeedReboot)GetProcAddress(hinst_drv_Lib, "esa_IsNeedReboot");
	bSucc_drv = esa_drv_IsNeedReboot();
	esa_mw_IsNeedReboot=(mw_IsNeedReboot)GetProcAddress(hinst_mw_Lib, "esa_IsNeedReboot");
	bSucc_mw = esa_mw_IsNeedReboot();
	if(( bSucc_drv )||(bSucc_mw))
		printf("Need reboot now\n");

	}
	fFreeResult = FreeLibrary(hinst_drv_Lib); 
	fFreeResult = FreeLibrary(hinst_mw_Lib); 

	getch();
	return 0;
}

/***********************************************************************/
/*  My callback function to get delete file opration status.
/***********************************************************************/
DWORD WINAPI MyDeleteProc(char* fName)
{
	printf("Delete %s (y/r/c ?)\n",fName);
	char ch = getchar();
	DWORD retval = NOTIFY_DELETEFILE_CANCEL;
	switch(ch)
	{
	case  'y':
	case  'Y':
		retval = NOTIFY_DELETEFILE_RETRY;
	break;
	case  'r':
	case  'R':
		retval = NOTIFY_DELETEFILE_REBOOT;
	break;
	case  'c':
	case  'C':
		retval = NOTIFY_DELETEFILE_CANCEL;
	break;		
	}	
	return retval;
}

/***********************************************************************/
/*  My callback function to get setup opration status.
/***********************************************************************/
void WINAPI MyProcessProc(char* sMsg)
{
	printf("%s...\n",sMsg);
}

/***********************************************************************/
/*  My callback function to get setup opration ERROR status.
/***********************************************************************/
void WINAPI MyErrProc(char* sMsg)
{
	printf("ERROR: %s...\n",sMsg);
}
