using System;
using System.Collections.Generic;
using System.Text;
using System.Runtime.InteropServices;

using ePasModLib;

namespace ConsoleApplication1
{
    class Program
    {
        static void Main(string[] args)
        {
            WFileInfo fi = new WFileInfo();
            WDirInfo di = new WDirInfo();
            WAccessInfo ai = new WAccessInfo();
            WVersionInfo vi = new WVersionInfo();
            WSysInfo si = new WSysInfo();
            String props = "";
            byte[] tText = new byte[128];
            byte[] rText = new byte[128];
            byte[] name = new byte[32];
            byte[] guid = new byte[16];

            String oText = "";
            String sText = "";

            int Low, Hiw, len, i;
            byte[] AppID = new byte[1024];
            int[] path = new int[8];
            int level;
            int nSize;
            int tSize;

            System.Console.WriteLine("start test private com ... ");
            //
            //ePasModLib.ePasClass epass = new ePasClass();
            ePasModLib.ePas1Class epass = new ePasModLib.ePas1Class();

            try
            {
                epass.CreateContext(0, 0x0200); //(0, &H200)
                System.Console.WriteLine("Try to open a token... ");
                epass.OpenDevice(1, AppID);
                oText = "";
                //property
                System.Console.WriteLine("GetProperty...");
                props = epass.GetProperty(0, "", 4);//EPAS_PROP_CAPABILITIES
                oText = "    Capability   : " + props + "";
                System.Console.WriteLine(oText);

                props = epass.GetProperty(1, "", 4);//EPAS_PROP_MEM_SIZE
                oText = "    Memory Size   : " + props + "";
                System.Console.WriteLine(oText);


                props = epass.GetProperty(0x0b, "", 32);//EPAS_PROP_FRIENDLY_NAME
                oText = "    Friendly Name   : " + props + "";
                System.Console.WriteLine(oText);

                props = epass.GetProperty(7, "", 8);//EPAS_PROP_SERNUM
                oText = "    Serial Number : ";
                oText = oText + props + "";
                System.Console.WriteLine(oText + "");

                epass.GetVersionInfo(ref vi);
                epass.GetSysInfo(ref si);
                epass.GetAccessInfo(3, ref ai);

                //create dir
                di.lID = 0x1000;
                di.lFlags = 0;
                epass.CreateDir(0, "", guid, ref di);
                System.Console.WriteLine("CreateDir 0x1000 succeed.");
                //choose dir
                epass.ChangeDir(0x200, 0x1000, "");  //flag.EPAS_DIR_BY_LONG_ID
                System.Console.WriteLine("ChangeDir To Dir 0x1000 succeed.");
                //choose parent dir                   
                epass.ChangeDir(0x20, 0, "");         //flag.EPAS_DIR_TO_PARENT

                epass.ChangeDir(0x20, 0, ""); //flag.EPAS_DIR_TO_PARENT
                System.Console.WriteLine("ChangeDir To Root Dir succeed. ");

                path = (int[])epass.GetCurrentDir(0, 8, out level);
                System.Console.WriteLine("GetCurrentPath succeed. ");
                oText = "    Current Path : ";
                for (i = 0; i < level; i++)
                {
                    oText = oText + "\\" + path[i].ToString();
                }
                System.Console.WriteLine(oText + "");

                fi.lID = 1;
                fi.lFlags = 0;
                fi.lFileSize = 4;
                fi.ucFileType = 0x02;       //flag.EPAS_FILETYPE_DATA 0x2;
                fi.ucReadAccess = 0x00;           //flag.EPAS_ACCESS_ANYONE;
                fi.ucWriteAccess = 0x00;                   //flag.EPAS_ACCESS_ANYONE;
                fi.ucCryptAccess = 0x07;                 //flag.EPAS_ACCESS_NONE;

                epass.CreateFile(0, ref fi);
                System.Console.WriteLine("CreatFile 1 succeed.");

                fi.lID = 2;
                fi.lFileSize = 64;
                fi.ucFileType = (byte)0x02;       //flag.EPAS_FILETYPE_DATA 0x2;
                fi.ucReadAccess = (byte)0x00;           //flag.EPAS_ACCESS_ANYONE;
                fi.ucWriteAccess = (byte)0x00;                   //flag.EPAS_ACCESS_ANYONE;
                fi.ucCryptAccess = (byte)0x07;                 //flag.EPAS_ACCESS_NONE;

                epass.CreateFile(0, ref fi);
                System.Console.WriteLine("CreatFile 2 succeed.");

                fi.lID = 3;
                fi.lFileSize = 16;
                fi.ucFileType = (byte)0x04;//flag.EPAS_FILETYPE_KEY;
                fi.ucReadAccess = (byte)0x00;//flag.EPAS_ACCESS_ANYONE;
                fi.ucWriteAccess = (byte)0x00;//flag.EPAS_ACCESS_ANYONE;
                fi.ucCryptAccess = (byte)0x00;//flag.EPAS_ACCESS_ANYONE;

                epass.CreateFile(0, ref fi);
                System.Console.WriteLine("CreatFile 3 succeed.");

                fi.lID = 4;
                fi.lFileSize = 16;
                fi.ucFileType = (byte)0x04;//flag.EPAS_FILETYPE_KEY;
                fi.ucReadAccess = (byte)0x00;//flag.EPAS_ACCESS_ANYONE;
                fi.ucWriteAccess = (byte)0x00;//flag.EPAS_ACCESS_ANYONE;
                fi.ucCryptAccess = (byte)0x00;//flag.EPAS_ACCESS_ANYONE;

                epass.CreateFile(0, ref fi);
                System.Console.WriteLine("CreatFile 4 succeed.");

                epass.GetFileInfo(0, 2, "", ref fi);
                System.Console.WriteLine("GetFileInfo 2 succeed.");


                epass.OpenFile(0x10 + 0x20, 1, ref  fi); //flag.EPAS_FILE_READ 0x10  flag.EPAS_FILE_WRITE 0x20
                System.Console.WriteLine("OpenFile 1 succeed.");

                tText[0] = tText[1] = tText[2] = tText[3] = 0x38;
                epass.Write(0, 0, tText, 4, out tSize);
                oText = "Write succeed. " + tSize.ToString() + " bytes written.<br>";
                System.Console.WriteLine(oText);
                tText = (byte[])(epass.Read(0, 0, 4, out tSize));

                System.Console.WriteLine("Read succeed. ");
                oText = "    File Content : ";
                for (i = 0; i < tSize; i++)
                {
                    Hiw = Low = tText[i];
                    Low &= 0xF;
                    Hiw >>= 4;
                    Hiw &= 0xF;
                    oText = oText + System.Convert.ToString(Hiw, 16) + System.Convert.ToString(Low, 16);
                }
                oText = oText + "";
                System.Console.WriteLine(oText);

                epass.CloseFile();
                System.Console.WriteLine("CloseFile 1 succeed.");

                epass.OpenFile(0x10 + 0x20, 2, ref fi);
                System.Console.WriteLine("OpenFile 2 succeed.");
                oText = "     Granted Access Right : 0x" + System.Convert.ToString(fi.ucGrantedAccess, 16) + "";
                System.Console.WriteLine(oText);

                sText = "Test data to be written to the file.";
                epass.Write(0, 0, sText, sText.Length, out tSize);
                oText = "Write succeed. " + tSize.ToString() + " bytes written.";
                System.Console.WriteLine(oText);

                tText = (byte[])epass.Read(0, 0, sText.Length, out tSize);
                oText = "Read succeed. " + tSize.ToString() + " bytes read.";
                System.Console.WriteLine(oText);

                epass.CloseFile();
                System.Console.WriteLine("CloseFile 2 succeed.");

                epass.OpenFile(0x20, 3, ref fi);
                System.Console.WriteLine("OpenFile 3 succeed.");

                rText[0] = 0x38;
                tText = (byte[])epass.GenRandom(0, 16);
                System.Console.WriteLine("GenRandom succeed.");
                epass.Write(0, 0, tText, 16, out tSize);
                oText = "Write succeed. " + tSize.ToString() + " bytes written.";
                System.Console.WriteLine(oText);
                epass.CloseFile();
                System.Console.WriteLine("CloseFile 3 succeed.");

                epass.OpenFile(0x20 + 0x40, 4, ref fi);
                System.Console.WriteLine("OpenFile 4 succeed.");
                epass.CloseFile();
                System.Console.WriteLine("CloseFile 4 succeed.");


                epass.DeleteFile(0, 4);
                System.Console.WriteLine("DeleteFile 4 succeed.");

                epass.DeleteFile(0, 3);
                System.Console.WriteLine("DeleteFile 3 succeed.");

                epass.DeleteFile(0, 2);
                System.Console.WriteLine("DeleteFile 2 succeed.");

                epass.DeleteFile(0, 1);
                System.Console.WriteLine("DeleteFile 1 succeed.");

                epass.ChangeDir(0x20, 0, "");
                System.Console.WriteLine("ChangeDir To Root Dir succeed.");

                epass.DeleteDir(0x200, 0x1000, "");
                System.Console.WriteLine("DeleteDir 0x1000 succeed.");

                epass.CloseDevice();
                epass.DeleteContext();
                System.Console.WriteLine("Close the opened token...");

            }
            catch (COMException exec)
            {

                epass.CloseDevice();
                epass.DeleteContext();
                System.Console.WriteLine("Access Key Exception...");
            }
        }
    }
}
