import epasjni.*;

public class ePsDemo
{
	// This routine converts bytes into hexadecimal representation
    public static char Hex(int bin) 
    {
        char retval;
        
        if (bin >= 0 && bin <= 9)
            retval = (char)('0' + bin);
        else if (bin >= 10 && bin <= 15)
            retval = (char)('A' + bin - 10);
        else
            retval = '0';
        return retval;
    }
    public static int B2Int(byte [] bina) 
    {
        int retval = 0;
        int t1 = 0;
        
        t1 = bina[3];
        retval = t1 & 0xFF;
        t1 = bina[2] & 0xFF;
        retval = retval * 0x100 + t1;
        t1 = bina[1] & 0xFF;
        retval = retval * 0x100 + t1;
        t1 = bina[0] & 0xFF;
        retval = retval * 0x100 + t1;
        return retval;
    }
	public static void main(String[] args)
	{
		IePass ePass = new CePass();
		ePassDef flag = new ePassDef();
		WFileInfo fi = new WFileInfo();
		WDirInfo  di = new WDirInfo();
		byte[] tText = new byte[64];
		byte[] rText = new byte[8];
		byte[] name  = new byte[32];
		byte[] guid  = new byte[16];
		int[]  tSize = new int[1];
		int[]  path  = new int[8];
		int[]  level = new int[1];
		String oText = "";
		String sText = "";
		int Low,Hiw,len;
		try
		{
			ePass.CreateContext(0,flag.EPAS_API_VERSION);
			System.out.println("Try to open a token...");
			ePass.OpenDevice(flag.EPAS_OPEN_FIRST,null);
			
			GetProps(ePass,flag);
			GenRandomNum(ePass);
			
			
			di.lID = 0x1000;
            di.lFlags = 0;
          
            sText = "ePass Java Demo";
            name = sText.getBytes();
                    
            guid[0] = 0x11;
            guid[1] = 0x11;
            guid[2] = 0x22;
            guid[3] = 0x22;
            guid[4] = 0x33;
            guid[5] = 0x33;
            guid[6] = 0x44;
            guid[7] = 0x44;
            guid[8] = 0x55;
            guid[9] = 0x55;
            guid[10] = 0x66;
            guid[11] = 0x66;
            guid[12] = 0x77;
            guid[13] = 0x77;
            guid[14] = (byte)0x88;
            guid[15] = (byte)0x88;
                  
            ePass.CreateDir(0 , name, guid, di);
            System.out.println("CreateDir 0x1000 succeed.");
            
            ePass.ChangeDir(flag.EPAS_DIR_BY_LONG_ID, 0x1000, null);
            System.out.println("ChangeDir To Dir 0x1000 succeed.");
                    
            ePass.ChangeDir(flag.EPAS_DIR_TO_PARENT, 0, null);
            System.out.println("ChangeDir To Root Dir succeed.");
                    
//            ePass.ChangeDir(flag.EPAS_DIR_BY_NAME, 0, name);
//            System.out.println("ChangeDir To Dir 0x1000 succeed.");
                    
            ePass.ChangeDir(flag.EPAS_DIR_TO_PARENT, 0, null);
            System.out.println("ChangeDir To Root Dir succeed.");
                    
//            ePass.ChangeDir(flag.EPAS_DIR_BY_GUID, 0, guid);
//            System.out.println("ChangeDir To Dir 0x10000 succeed.");

            ePass.GetCurrentDir(0, path, 8, level);
            System.out.println("GetCurrentPath succeed.");
            oText = "    Current Path : ";
            for (int i = 0; i < level[0]; i ++)
            {
                oText = oText + "\\" + Integer.toHexString(path[i]);
            }
            System.out.println(oText);
            
            fi.lID = 1;
            fi.lFlags = 0;
            fi.lFileSize = 4;
            fi.chFileType = (byte)flag.EPAS_FILETYPE_DATA;
            fi.chReadAccess = (byte)flag.EPAS_ACCESS_ANYONE;
            fi.chWriteAccess = (byte)flag.EPAS_ACCESS_ANYONE;
            fi.chCryptAccess = (byte)flag.EPAS_ACCESS_NONE;
                    
            ePass.CreateFile(0, fi);
            System.out.println("CreatFile 1 succeed.");
                    
            fi.lID = 2;
            fi.lFileSize = 64;
            fi.chFileType = (byte)flag.EPAS_FILETYPE_DATA;
            fi.chReadAccess = (byte)flag.EPAS_ACCESS_ANYONE;
            fi.chWriteAccess = (byte)flag.EPAS_ACCESS_ANYONE;
            fi.chCryptAccess = (byte)flag.EPAS_ACCESS_NONE;
                    
            ePass.CreateFile(0, fi);
            System.out.println("CreatFile 2 succeed.");
                    
            fi.lID = 3;
            fi.lFileSize = 16;
            fi.chFileType = (byte)flag.EPAS_FILETYPE_KEY;
            fi.chReadAccess = (byte)flag.EPAS_ACCESS_ANYONE;
            fi.chWriteAccess = (byte)flag.EPAS_ACCESS_ANYONE;
            fi.chCryptAccess = (byte)flag.EPAS_ACCESS_ANYONE;
                    
            ePass.CreateFile(0, fi);
            System.out.println("CreatFile 3 succeed.");
                   
            fi.lID = 4;
            fi.lFileSize     = 16;
            fi.chFileType    = (byte)flag.EPAS_FILETYPE_KEY;
            fi.chReadAccess  = (byte)flag.EPAS_ACCESS_ANYONE;
            fi.chWriteAccess = (byte)flag.EPAS_ACCESS_ANYONE;
            fi.chCryptAccess = (byte)flag.EPAS_ACCESS_ANYONE;
                    
            ePass.CreateFile(0, fi);
            System.out.println("CreatFile 4 succeed.");
                    
			ePass.GetFileInfo(0, 2, null, fi);
            System.out.println("GetFileInfo 2 succeed.");
            System.out.println("    ID : 0x" + Integer.toHexString(fi.lID) + "   TYPE : 0x" + Integer.toHexString(fi.chFileType) + "   SIZE : 0x" + Integer.toHexString(fi.lFileSize));
            System.out.println("    Read : 0x" + Integer.toHexString(fi.chReadAccess) + "   Write : 0x" + Integer.toHexString(fi.chWriteAccess) + "   Crypt : 0x" + Integer.toHexString(fi.chCryptAccess));

		
		    ePass.OpenFile(flag.EPAS_FILE_READ + flag.EPAS_FILE_WRITE, 1, fi);
            System.out.println("OpenFile 1 succeed.");
            System.out.println("     Granted Access Right : 0x" + Integer.toHexString(fi.chGrantedAccess));
                    
            tText[0] = tText[1] = tText[2] = tText[3] = 0x38;
            
            ePass.Write(0, 0, tText, 4, tSize);
            System.out.println("Write succeed. " + Integer.toString(tSize[0]) + " bytes written.");
                    
            ePass.Read(0, 0, tText, 4, tSize);
			System.out.println("Read succeed. " + Integer.toString(tSize[0]) + " bytes read.");
			oText = "    File Content : ";
            for (int i = 0; i < tSize[0]; i ++)
            {
            	Hiw = Low = tText[i];
                Low &= 0xF;
                Hiw >>= 4;
                Hiw &= 0xF;
                                    
                oText = oText + Hex(Hiw) + Hex(Low);
            }
            System.out.println(oText);
                    
            ePass.Read(0, 0, tText, 4, tSize);
            System.out.println("Read succeed. " + Integer.toString(tSize[0]) + " bytes read.");
            oText = "    File Content : ";
            for (int i = 0; i < tSize[0]; i ++)
            {
                Hiw = Low = tText[i];
                Low &= 0xF;
                Hiw >>= 4;
                Hiw &= 0xF;
                oText = oText + Hex(Hiw) + Hex(Low);
             }
             System.out.println(oText);
                    
             ePass.CloseFile();
             System.out.println("CloseFile 1 succeed.");
                    
             ePass.OpenFile(flag.EPAS_FILE_READ + flag.EPAS_FILE_WRITE, 2, fi);
			 System.out.println("OpenFile 2 succeed.");
             System.out.println("     Granted Access Right : 0x" + Integer.toHexString(fi.chGrantedAccess));
                    
             sText = "Test data to be written to the file.";
             ePass.Write(0, 0, sText.getBytes(), sText.length(), tSize);
             System.out.println("Write succeed. " + Integer.toString(tSize[0]) + " bytes written.");
                    
             ePass.Read(0, 0, tText, 64, tSize);
             System.out.println("Read succeed. " + Integer.toString(tSize[0]) + " bytes read.");
             for (len = 0; len < 64 && tText[len] != 0; len ++);
             sText = new String(tText, 0, len);
             oText = "    File Content : " + sText;
             System.out.println(oText);
                                
             ePass.CloseFile();
             System.out.println("CloseFile 2 succeed.");
                    
             ePass.OpenFile(flag.EPAS_FILE_WRITE, 3, fi);
             System.out.println("OpenFile 3 succeed.");
             System.out.println("     Granted Access Right : 0x" + Integer.toHexString(fi.chGrantedAccess));
             
             rText[0] = 0x38;       
             ePass.GenRandom(0, rText, tText, 16);
             ePass.Write(0, 0, tText, 16, tSize);
             System.out.println("Write succeed. " + Integer.toString(tSize[0]) + " bytes written.");
                    
             ePass.CloseFile();
             System.out.println("CloseFile 3 succeed.");
                    
             ePass.OpenFile(flag.EPAS_FILE_WRITE + flag.EPAS_FILE_CRYPT, 4, fi);
             System.out.println("OpenFile 4 succeed.");
             System.out.println("     Granted Access Right : 0x" + Integer.toHexString(fi.chGrantedAccess));
                    
             ePass.GenRandom(0, rText, rText, 8);
             ePass.Write(0, 0, rText, 8, tSize);
             System.out.println("Write succeed. " + Integer.toString(tSize[0]) + " bytes written.");
                    
             ePass.HashToken(flag.EPAS_HASH_MD5_HMAC, 4, rText, 8, tText, 16, tSize); 
             System.out.println("HashToken succeed. " + Integer.toString(tSize[0]) + " bytes returned.");
             oText = "    Data : ";
             for (int i = 0; i < 8; i ++)
             {
             	Hiw = Low = rText[i];
                Low &= 0xF;
                Hiw >>= 4;
                Hiw &= 0xF;
                                    
                oText = oText + Hex(Hiw) + Hex(Low);
             }
             System.out.println(oText);
                    
             oText = "    Digest : ";
             for (int i = 0; i < 16; i ++)
             {
             	Hiw = Low = tText[i];
                Low &= 0xF;
                Hiw >>= 4;
                Hiw &= 0xF;
                oText = oText + Hex(Hiw) + Hex(Low);
             }
             System.out.println(oText);
                    
             ePass.CloseFile();
             System.out.println("CloseFile 4 succeed.");
                    
             ePass.DeleteFile(0, 4);
             System.out.println("DeleteFile 4 succeed.");
                    
             ePass.DeleteFile(0, 3);
             System.out.println("DeleteFile 3 succeed.");
                    
             ePass.DeleteFile(0, 2);
             System.out.println("DeleteFile 2 succeed.");
                    
             ePass.DeleteFile(0, 1);
             System.out.println("DeleteFile 1 succeed.");
                    
             ePass.ChangeDir(flag.EPAS_DIR_TO_PARENT, 0, null);
             System.out.println("ChangeDir To Root Dir succeed.");
                    
             ePass.DeleteDir(flag.EPAS_DIR_BY_LONG_ID, 0x1000, null);
             System.out.println("DeleteDir 0x1000 succeed.");		
			
						
			System.out.println("Close the opened token...");
			ePass.CloseDevice();
			ePass.DeleteContext();
		}
		catch(RTException e)
		{
			System.out.println(e.HResult()+":"+e.getMessage());
		}
	}
	public static void GenRandomNum(IePass ePass)
	{
		byte[] rbuff = new byte[8];
		int  Hiw, Low;
		String oText = "";
        
        ePass.GenRandom(0,rbuff,rbuff,8);
        System.out.print("GenRandom...\n");
        oText = "    Random Number : ";
        for (int i = 0; i < 8; i ++)
        {
           Hiw = Low = rbuff[i];
           Low &= 0xF;
           Hiw >>= 4;
           Hiw &= 0xF;
           oText = oText + Hex(Hiw) + Hex(Low);
        }
        System.out.print(oText + "\n");
	}
	public static void GetProps(IePass ePass,ePassDef flag)
	{
		byte [] props = new byte[32];
		int  Hiw, Low;
		String oText = "";
		String tText = "";
		int         len = 0;
		int         property = 0;
		
        System.out.print("GetProperty...\n");
        ePass.GetProperty(flag.EPAS_PROP_CAPABILITIES, null, props, 4);
        property = B2Int(props);
        oText = "    Capability   : " + Integer.toHexString(property);
       	System.out.print(oText + "\n");
                    
        ePass.GetProperty(flag.EPAS_PROP_MEM_SIZE, null, props, 4);
        property = B2Int(props);
        oText = "    Memory Size   : " + Integer.toString(property);
        System.out.print(oText + "\n");
                    
        ePass.GetProperty(flag.EPAS_PROP_FRIENDLY_NAME, null, props, 32);
        for (len = 0; len < 32 && props[len] != 0; len ++);
        	tText = new String(props, 0, len);
        oText = "    Friendly Name   : " + tText;
        System.out.print(oText + "\n");

        ePass.GetProperty(flag.EPAS_PROP_SERNUM, null, props, 8);
        oText = "    Serial Number : ";
        for (int i = 7; i >= 0; i --)
        {
           Hiw = Low = props[i];
           Low &= 0xF;
           Hiw >>= 4;
           Hiw &= 0xF;
                        
           oText = oText + Hex(Hiw) + Hex(Low);
        }
        System.out.print(oText + "\n");
        
        WVersionInfo vi = new WVersionInfo();
        ePass.GetVersionInfo(vi);
        
        System.out.println("GetVersionInfo succeeded.");
        int Major,Middle,Minor;
        long Build;
        Major = (vi.lDrvVer & 0xff000000) >> 24;
        Middle = (vi.lDrvVer & 0xff0000) >> 16;
        Minor = (vi.lDrvVer & 0xff00) >> 8;
        Build = (vi.lDrvVer & 0xffff);
        System.out.println("    Driver Version   : " + Major + "." + Middle + "." + Minor + "." + Build);
        System.out.println("    Driver Version   : " + Integer.toHexString(vi.lDrvVer));
        System.out.println("    Firmware Version : " + Integer.toHexString(vi.chFwVerMajor) + 
                           "." + Integer.toHexString(vi.chFwVerMinor) + 
                           "." + Integer.toHexString(vi.chProductCode));
	
		WSysInfo si = new WSysInfo();		                    
		ePass.GetSysInfo(si);
		System.out.println("GetSysInfo succeeded.");
		System.out.println("    Free Space : " + si.lFreeSpace + "bytes");
        System.out.println("    File System Type : " + Integer.toHexString(si.chFileSysType) + "  Maximum Dir Level : " + Integer.toHexString(si.chMaxDirLevels));
                    
        WAccessInfo ai = new WAccessInfo();
        ePass.GetAccessInfo(flag.EPAS_PROP_ACCESSINFO, ai);
		System.out.println("GetAccessInfo succeeded.");
		System.out.println("    MaxPinRetries : " + Integer.toString(ai.chMaxPinRetries));
		System.out.println("    CurPinCounter : " + Integer.toString(ai.chCurPinCounter));
        System.out.println("    CreateAccess  : " + Integer.toString(ai.chCreateAccess));
        System.out.println("    DeleteAccess  : " + Integer.toString(ai.chDeleteAccess));
	}
}
