//************************************************************************/
// [Caution]: this sample is only a demo how to install ePass1000 driver,
//            If you want to install ePass1000 middleware, please change the
//	      "ePsInst_drv.dll" to "ePsInst_mw.dll",
//            and change the parameter "/c2" of esa_DoInstall() to "/a"
//***********************************************************************/
unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls;

type
  TForm1 = class(TForm)
    rBtn1: TRadioButton;
    rBtn2: TRadioButton;
    BtnStart: TButton;
    Label1: TLabel;
    procedure BtnStartClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;
var
  Form1: TForm1;

implementation

{$R *.DFM}
uses
    epsSetupApi;

procedure TForm1.BtnStartClick(Sender: TObject);
var
    bSucc:boolean;
begin
    bSucc := false;
    if(rBtn1.Checked)then
    begin
        bSucc := esa_DoInstall('/c2');
    end
    else if(rBtn2.Checked) then
    begin
        bSucc := esa_DoUninstall(' ');
    end;
    if(bSucc)then
        ShowMessage('Success')
    else
        ShowMessage('Failed');
    if(esa_IsNeedReboot())then
        ShowMessage('Need reboot now');
end;

function MyDeleteProc(strMsg:PChar):DWORD;stdcall;
var
    strShow:string;
    mr :integer;
    retval :integer;
begin
    retval := NOTIFY_DELETEFILE_CANCEL;
    strShow := 'Try to Delete ' + strMsg + '  Y(Retry)  or  N(Reboot)  or  C(Cancel)';

    mr := Application.MessageBox(PChar(strShow),'notify',MB_YESNOCANCEL);
    if (mr = IDYES) then
        retval := NOTIFY_DELETEFILE_RETRY
    else if (mr = IDNO) then
        retval := NOTIFY_DELETEFILE_REBOOT
    else if (mr = IDCANCEL) then
        retval := NOTIFY_DELETEFILE_CANCEL;
    result := retval;
end;

procedure MyProcessProc(strMsg:PChar);stdcall;
begin
    Form1.Label1.Caption := strMsg;
    Form1.Repaint();
end;

procedure MyErrProc(strMsg:PChar);stdcall;
begin
    ShowMessage(strMsg);
end;

procedure TForm1.FormCreate(Sender: TObject);
begin
    esa_SetDeleteFileCallback(MyDeleteProc);
    esa_SetShowMsgNotifyCallBack(MyProcessProc);
    esa_SetShowErrMsgNotifyCallBack(MyErrProc);
end;

end.
