/***********************************************************************/
/*
/* epsSetup.cpp : A simple program that demo how to use parameter
/*                      to install ePass1000 driver.
/*
/* Create date:         03/18/2003.
/*
/* Create by:           Feitian Tech. Co., Ltd.
/*
/***********************************************************************/

#include "stdafx.h"
#include <conio.h>
#include "epsSetupApi.h"

/***********************************************************************/
/* Callback Function which get ePass1000 driver setup operation status.
/* if you don't care the output infomation, you can ingore these.
/***********************************************************************/
DWORD	WINAPI MyDeleteProc(char* fName);
void	WINAPI MyProcessProc(char* sMsg);
void	WINAPI MyErrProc(char* sMsg);

int main(int argc, char* argv[])
{
	bool bSucc = false;
	char ch;

	printf("/*************************************************************/\n");
	printf("               ePass 1000 driver setup demo!                   \n");
	printf("/*************************************************************/\n");

	esa_SetDeleteFileCallback(MyDeleteProc);
	esa_SetShowMsgNotifyCallback(MyProcessProc);
	esa_SetShowErrMsgNotifyCallback(MyErrProc);

	/***********************************************************************/
	/*  Step 1: first detect current system if has installed ePass1000 driver
	/*          before.
	/***********************************************************************/
	int iRes = esa_IsHaveInstalled();

	/************************************************************************/
	/* If the current system has installed ePass1000 driver before, and their
	/* versions are older, new or equal the one to be installed , then I select
	/* show "Reinstall" and "Uninstall", you can select case by youself.
	/************************************************************************/
	if( iRes == ESA_DEST_DVERSION_OLD )
	{
		printf("select 1 to Reinstall\n");
		printf("select 2 to Uninstall\n");
		ch = getchar();

		/***********************************************************************/
		/*  Step 2: If has installed before, user should can select reinstall or 
		/*          uninstall
		/*          and the "/c1" mean install 1 devices to system.
		/***********************************************************************/
		if(ch == '1')
			bSucc = esa_DoInstall("/c1");
		else
			bSucc = esa_DoUninstall("");
	}	
	else
	{
		/***********************************************************************/
		/*  Step 3: If has NOT installed before, user should can Install.
		/*          and the "/c1" mean install 1 devices to system.
		/***********************************************************************/
		printf("select 1 to Install\n");	
		ch = getchar();

		if(ch == '1')
			bSucc = esa_DoInstall("/c1");	
	}	

	/***********************************************************************/
	/*  Step 4: Output setup result and decide if need reboot.
	/***********************************************************************/
	printf("setup %s\n",bSucc?"success":"failed");

	bSucc = esa_IsNeedReboot();
	if( bSucc )
		printf("Need reboot now\n");	
	
	getch();
	return 0;
}

/***********************************************************************/
/*  My callback function to get delete file opration status.
/***********************************************************************/
DWORD WINAPI MyDeleteProc(char* fName)
{
	printf("Delete %s (y/r/c ?)\n",fName);
	char ch = getchar();
	DWORD retval = NOTIFY_DELETEFILE_CANCEL;
	switch(ch)
	{
	case  'y':
	case  'Y':
		retval = NOTIFY_DELETEFILE_RETRY;
	break;
	case  'r':
	case  'R':
		retval = NOTIFY_DELETEFILE_REBOOT;
	break;
	case  'c':
	case  'C':
		retval = NOTIFY_DELETEFILE_CANCEL;
	break;		
	}	
	return retval;
}

/***********************************************************************/
/*  My callback function to get setup opration status.
/***********************************************************************/
void WINAPI MyProcessProc(char* sMsg)
{
	printf("%s...\n",sMsg);
}

/***********************************************************************/
/*  My callback function to get setup opration ERROR status.
/***********************************************************************/
void WINAPI MyErrProc(char* sMsg)
{
	printf("ERROR: %s...\n",sMsg);
}