Option Strict Off
Option Explicit On
Imports VB = Microsoft.VisualBasic
Friend Class frmMain
	Inherits System.Windows.Forms.Form
	'Some global variable used in create/remove directory for demonstration.
	'GUID : {0B28853F-E4C1-4ADE-AC61-A6062EA8F099}
	Dim epsGUID(15) As Byte
	Dim epsAppName(EPAS_APP_NAME_SIZE - 1) As Byte
	Dim epsStrAppName As String
	
	Private Function CreateDemoDir(DirID As  Integer) As Object
        'Create a directory for demonstration.
        'ePass.CreateDir((EPAS_DIR_BY_GUID Or EPAS_CREATE_AUTO_ID), CStr(epsAppName(0)), epsGUID(0), epsDirInfo)
        epsDirInfo.lID = DirID
        ePass.CreateDir(0, epsStrAppName, epsGUID, epsDirInfo)
        CheckOP("Create a directory for demo")
    End Function
	
	Private Function RemoveDemoDir(DirID As Integer) As Object
        'Remove the demo-directory.
        ePass.ChangeDir(&H20, 0, "")
        ePass.DeleteDir(&H200, DirID, "")
        'ePass.DeleteDir(EPAS_DIR_BY_GUID, 0, CStr(epsGUID(0)))
        CheckOP("Remove the demo-directory")
    End Function
	
	Private Sub ShowInfo(ByRef txtColor As Integer, ByRef Info As String)
		txtInfo.SelectionStart = Len(txtInfo.Text)
		txtInfo.SelectionColor = System.Drawing.ColorTranslator.FromOle(txtColor)
		txtInfo.SelectedText = Info & vbNewLine
	End Sub
	
	Private Sub ShowResult(ByRef Info As String)
		ShowInfo(System.Drawing.ColorTranslator.ToOle(System.Drawing.Color.Blue), "  => " & Info)
	End Sub
	
	Private Sub ShowHint(ByRef Info As String)
		ShowInfo(System.Drawing.ColorTranslator.ToOle(System.Drawing.Color.Black), "* " & Info)
	End Sub
	
	Private Sub ShowByteArray(ByRef Data() As Byte, ByRef lSize As Integer)
		Dim strInfo As String
		Dim strTemp As String
		
		Dim i As Integer
		Dim n As Integer
		Dim lShowed As Integer
		
		'If there are nothing to show, just do nothing.
		If lSize <= 0 Then
			Exit Sub
		End If
		
		strInfo = " >>>> "
		lShowed = 0
		
		While lSize > 0
			If lSize > 8 Then
				n = 8
			Else
				n = lSize
			End If
			
			For i = 0 To n - 1
				strTemp = ""
				strTemp = Hex(Data(i + lShowed)) & " "
				If Data(i + lShowed) < &H10s Then strTemp = "0" & strTemp
				strInfo = strInfo & strTemp
				
				'strInfo = strInfo & hex(Data(i + lShowed))
			Next i
			
			While i < 8
				strInfo = strInfo & "   "
				i = i + 1
			End While
			
			strInfo = strInfo & "   ["
			For i = 0 To n - 1
				'strTemp.printf( "%c", (*lpData < 32 || *lpData > 127) ? '.' : *lpData );
				'strTemp = ""
				If Data(i + lShowed) < 32 Or Data(i + lShowed) > 127 Then
					strTemp = "."
				Else
					strTemp = Chr(Data(i + lShowed))
				End If
				strInfo = strInfo & strTemp
				
				'strInfo = strInfo & hex(Data(i + lShowed))
			Next i
			
			While i < 8
				strInfo = strInfo & " "
				i = i + 1
			End While
			
			strInfo = strInfo & "]"
			
			lShowed = lShowed + n
			lSize = lSize - n
			
			If lSize > 0 Then
				strInfo = strInfo & vbNewLine
				strInfo = strInfo & " >>>> "
			End If
		End While
		ShowInfo(System.Drawing.ColorTranslator.ToOle(System.Drawing.Color.Red), strInfo)
	End Sub
	
	'Convert the Err.Number to the error code defined by Feitian  Tech.
	Private Function ConvertErrorCode() As Object
		Dim ErrCode As Byte
		Dim S As String
		Dim M As String
		
		S = Hex(Err.Number)
		M = VB.Right(S, 2)
		ErrCode = Val("&H" & M)
		'UPGRADE_WARNING: Couldn't resolve default property of object ConvertErrorCode. Click for more: 'ms-help://MS.VSCC.v80/dv_commoner/local/redirect.htm?keyword="6A50421D-15FE-4896-8A1B-2EC21E9037B2"'
		ConvertErrorCode = ErrCode
	End Function
	
	Private Sub ShowError(ByRef Info As String)
		Dim ErrCode As Byte
		
		ShowInfo(System.Drawing.ColorTranslator.ToOle(System.Drawing.Color.Red), "* " & Info)
		
		'UPGRADE_WARNING: Couldn't resolve default property of object ConvertErrorCode. Click for more: 'ms-help://MS.VSCC.v80/dv_commoner/local/redirect.htm?keyword="6A50421D-15FE-4896-8A1B-2EC21E9037B2"'
		ErrCode = ConvertErrorCode
		
		If FT_CANNOT_OPEN_DRIVER = ErrCode Then
			Info = "Can't open the driver."
		ElseIf FT_INVALID_DRVR_VERSION = ErrCode Then 
			Info = "Driver version not supported."
		ElseIf FT_INVALID_COMMAND = ErrCode Then 
			Info = "Invalid command sent to API."
		ElseIf FT_ACCESS_DENIED = ErrCode Then 
			Info = "Access denied."
		ElseIf FT_ALREADY_ZERO = ErrCode Then 
			Info = "Counter already zero."
		ElseIf FT_UNIT_NOT_FOUND = ErrCode Then 
			Info = "Device not found."
		ElseIf FT_DEVICE_REMOVED = ErrCode Then 
			Info = "Device removed."
		ElseIf FT_COMMUNICATIONS_ERROR = ErrCode Then 
			Info = "Device communication error."
		ElseIf FT_DIR_NOT_FOUND = ErrCode Then 
			Info = "Directory does not exist."
		ElseIf FT_FILE_NOT_FOUND = ErrCode Then 
			Info = "File not found."
		ElseIf FT_MEM_CORRUPT = ErrCode Then 
			Info = "Device memory is corrupted."
		ElseIf FT_INTERNAL_HW_ERROR = ErrCode Then 
			Info = "Internal hardware error."
		ElseIf FT_INVALID_RESP_SIZE = ErrCode Then 
			Info = "Invalid response received from the device."
		ElseIf FT_PIN_EXPIRED = ErrCode Then 
			Info = "PIN retry attempts has expired."
		ElseIf FT_ALREADY_EXISTS = ErrCode Then 
			Info = "Directory or file already exist."
		ElseIf FT_NOT_ENOUGH_MEMORY = ErrCode Then 
			Info = "Not enough memory to perform the operation."
		ElseIf FT_INVALID_PARAMETER = ErrCode Then 
			Info = "Invalid parameter sent to API."
		ElseIf FT_INPUT_TOO_LONG = ErrCode Then 
			Info = "Input data is too long."
		ElseIf FT_INVALID_FILE_SELECTED = ErrCode Then 
			Info = "Invalid file selected or operation."
		ElseIf FT_DEVICE_IN_USE = ErrCode Then 
			Info = "The device is currently in use."
		ElseIf FT_INVALID_API_VERSION = ErrCode Then 
			Info = "The version of this library is not supported."
		ElseIf FT_TIME_OUT_ERROR = ErrCode Then 
			Info = "Communication time-out."
		ElseIf FT_ITEM_NOT_FOUND = ErrCode Then 
			Info = "Item not found."
		ElseIf FT_COMMAND_ABORTED = ErrCode Then 
			Info = "Communication error, command aborted."
		ElseIf FT_INVALID_STATUS = ErrCode Then 
			Info = "Invalid status."
		Else
			Info = "An unknown error occurred."
		End If
		ShowInfo(System.Drawing.ColorTranslator.ToOle(System.Drawing.Color.Red), "  => " & Info)
	End Sub
	
	'Convert the access code to string
	Private Function AccessToString(ByRef AccessCode As Byte) As Object
		If AccessCode = EPAS_ACCESS_ANYONE Then
			'UPGRADE_WARNING: Couldn't resolve default property of object AccessToString. Click for more: 'ms-help://MS.VSCC.v80/dv_commoner/local/redirect.htm?keyword="6A50421D-15FE-4896-8A1B-2EC21E9037B2"'
			AccessToString = "ALWAYS"
		ElseIf AccessCode = EPAS_ACCESS_USER Then 
			'UPGRADE_WARNING: Couldn't resolve default property of object AccessToString. Click for more: 'ms-help://MS.VSCC.v80/dv_commoner/local/redirect.htm?keyword="6A50421D-15FE-4896-8A1B-2EC21E9037B2"'
			AccessToString = "PIN"
		ElseIf AccessCode = EPAS_ACCESS_OFFICER Then 
			'UPGRADE_WARNING: Couldn't resolve default property of object AccessToString. Click for more: 'ms-help://MS.VSCC.v80/dv_commoner/local/redirect.htm?keyword="6A50421D-15FE-4896-8A1B-2EC21E9037B2"'
			AccessToString = "MASTER"
		ElseIf AccessCode = EPAS_ACCESS_NONE Then 
			'UPGRADE_WARNING: Couldn't resolve default property of object AccessToString. Click for more: 'ms-help://MS.VSCC.v80/dv_commoner/local/redirect.htm?keyword="6A50421D-15FE-4896-8A1B-2EC21E9037B2"'
			AccessToString = "NONE"
		End If
	End Function
	
	'Convert the capability code to string
	Private Function CapabilitiesToString(ByRef CapCode As Integer) As Object
		Dim Info As String
		Info = ""
		If EPAS_CAPS_MD5HMAC = (CapCode And EPAS_CAPS_MD5HMAC) Then
			Info = Info & "MD5-HMAC "
		End If
		'UPGRADE_WARNING: IsEmpty was upgraded to IsNothing and has a new behavior. Click for more: 'ms-help://MS.VSCC.v80/dv_commoner/local/redirect.htm?keyword="9B7D5ADD-D8FE-4819-A36C-6DEDAF088CC7"'
		If IsNothing(Info) Then
			Info = "N/A"
		End If
		'UPGRADE_WARNING: Couldn't resolve default property of object CapabilitiesToString. Click for more: 'ms-help://MS.VSCC.v80/dv_commoner/local/redirect.htm?keyword="6A50421D-15FE-4896-8A1B-2EC21E9037B2"'
		CapabilitiesToString = Info
	End Function
	
	'Get the information of the opened device
	Private Function GetDeviceInfo() As Object
		On Error Resume Next
		Dim Prop(31) As Byte
		Dim Info As String
		Dim epsStrTokenName As String
        Dim epsMemSize As String
		'Dim epsTokenName(0 To EPAS_FRIENDLY_NAME_SIZE - 1) As Byte
		Dim ErrorCode As Integer
		
		'Get the serial number
        epsSerialNumStr = ePass.GetProperty(EPAS_PROP_SERNUM, " ", 128)
		'UPGRADE_WARNING: Couldn't resolve default property of object CheckOP(Get the serial number). Click for more: 'ms-help://MS.VSCC.v80/dv_commoner/local/redirect.htm?keyword="6A50421D-15FE-4896-8A1B-2EC21E9037B2"'
		If False = CheckOP("Get the serial number") Then
			'UPGRADE_WARNING: Couldn't resolve default property of object GetDeviceInfo. Click for more: 'ms-help://MS.VSCC.v80/dv_commoner/local/redirect.htm?keyword="6A50421D-15FE-4896-8A1B-2EC21E9037B2"'
			GetDeviceInfo = False
			Exit Function
		Else
			Info = ""
            'HexToString(epsSerialNum, Info, 8)
            Info = "Serial Number ........... : 0x" & epsSerialNumStr
			ShowResult(Info)
		End If
		
		'Get token name
        epsStrTokenName = ePass.GetProperty(EPAS_PROP_FRIENDLY_NAME, " ", 128)
		'If Err.Number = FT_ITEM_NOT_FOUND, it's means you never
		'  set a token-name for this token and just skip it.
		'UPGRADE_WARNING: Couldn't resolve default property of object ConvertErrorCode(). Click for more: 'ms-help://MS.VSCC.v80/dv_commoner/local/redirect.htm?keyword="6A50421D-15FE-4896-8A1B-2EC21E9037B2"'
		ErrorCode = ConvertErrorCode()
		If ErrorCode = FT_SUCCESS Or ErrorCode = FT_ITEM_NOT_FOUND Then
			'Must clear the error flag. Otherwise, the follow function call may failed.
			Err.Clear()
			ShowInfo(System.Drawing.ColorTranslator.ToOle(System.Drawing.Color.Black), "* Get token name successful.")
			Info = "Token name .............. : "
			If ErrorCode = FT_SUCCESS Then
                'ByteArrayToString(epsStrTokenName, Prop, EPAS_FRIENDLY_NAME_SIZE)
				Info = Info & epsStrTokenName
			Else
				Info = Info & "{Not defined.}"
			End If
			ShowResult(Info)
		Else
			CheckOP("Get the token name")
			'UPGRADE_WARNING: Couldn't resolve default property of object GetDeviceInfo. Click for more: 'ms-help://MS.VSCC.v80/dv_commoner/local/redirect.htm?keyword="6A50421D-15FE-4896-8A1B-2EC21E9037B2"'
			GetDeviceInfo = False
			Exit Function
		End If
		
		'Get the version information
		ePass.GetVersionInfo(epsVersionInfo)
		'UPGRADE_WARNING: Couldn't resolve default property of object CheckOP(Get the version information). Click for more: 'ms-help://MS.VSCC.v80/dv_commoner/local/redirect.htm?keyword="6A50421D-15FE-4896-8A1B-2EC21E9037B2"'
		If False = CheckOP("Get the version information") Then
			'UPGRADE_WARNING: Couldn't resolve default property of object GetDeviceInfo. Click for more: 'ms-help://MS.VSCC.v80/dv_commoner/local/redirect.htm?keyword="6A50421D-15FE-4896-8A1B-2EC21E9037B2"'
			GetDeviceInfo = False
			Exit Function
		Else
			'Driver version
			Info = ""
			VersionToString((epsVersionInfo.lDriverVersion), Info)
			ShowResult("Driver API version ...... : " & Info)
			
			'Firmware Version
			Info = ""
			Info = Trim(Str(epsVersionInfo.ucFwVerMajor)) & "." & Trim(Str(epsVersionInfo.ucFwVerMinor))
			Info = "Firmware Version ........ : " & Info
			ShowResult(Info)
			
			'Product Code
			Info = "Product code ............ : 0x"
			Info = Info & Hex(epsVersionInfo.ucProductCode)
			ShowResult(Info)
		End If
		
		'Get memory size
        epsMemSize = ePass.GetProperty(EPAS_PROP_MEM_SIZE, " ", 128)
		'UPGRADE_WARNING: Couldn't resolve default property of object CheckOP(Get the size of memory). Click for more: 'ms-help://MS.VSCC.v80/dv_commoner/local/redirect.htm?keyword="6A50421D-15FE-4896-8A1B-2EC21E9037B2"'
		If False = CheckOP("Get the size of memory") Then
			'UPGRADE_WARNING: Couldn't resolve default property of object GetDeviceInfo. Click for more: 'ms-help://MS.VSCC.v80/dv_commoner/local/redirect.htm?keyword="6A50421D-15FE-4896-8A1B-2EC21E9037B2"'
			GetDeviceInfo = False
			Exit Function
		Else
            'ByteArrayToLong(epsMemSize, Prop)
			ShowResult("Memory size ............. : " & epsMemSize & " bytes.")
		End If
		
		'Get system information
		ePass.GetSysInfo(epsSysInfo)
		'UPGRADE_WARNING: Couldn't resolve default property of object CheckOP(Get system information). Click for more: 'ms-help://MS.VSCC.v80/dv_commoner/local/redirect.htm?keyword="6A50421D-15FE-4896-8A1B-2EC21E9037B2"'
		If False = CheckOP("Get system information") Then
			'UPGRADE_WARNING: Couldn't resolve default property of object GetDeviceInfo. Click for more: 'ms-help://MS.VSCC.v80/dv_commoner/local/redirect.htm?keyword="6A50421D-15FE-4896-8A1B-2EC21E9037B2"'
			GetDeviceInfo = False
			Exit Function
		Else
			ShowResult("Flags ................... :" & Str(epsSysInfo.lFlags))
			ShowResult("Free space .............. :" & Str(epsSysInfo.lFreeSpace) & " bytes")
			ShowResult("File system type ........ :" & Str(epsSysInfo.ucFileSysType))
			ShowResult("Max directory levels .... :" & Str(epsSysInfo.ucMaxDirLevels))
		End If
		
		'Get access information
		ePass.GetAccessInfo(EPAS_PROP_ACCESSINFO, epsAccessInfo)
		'UPGRADE_WARNING: Couldn't resolve default property of object CheckOP(Get access information). Click for more: 'ms-help://MS.VSCC.v80/dv_commoner/local/redirect.htm?keyword="6A50421D-15FE-4896-8A1B-2EC21E9037B2"'
		If False = CheckOP("Get access information") Then
			'UPGRADE_WARNING: Couldn't resolve default property of object GetDeviceInfo. Click for more: 'ms-help://MS.VSCC.v80/dv_commoner/local/redirect.htm?keyword="6A50421D-15FE-4896-8A1B-2EC21E9037B2"'
			GetDeviceInfo = False
			Exit Function
		Else
			ShowResult("Max PIN retries ......... :" & Str(epsAccessInfo.ucMaxPinRetries))
			ShowResult("Current PIN retries ..... :" & Str(epsAccessInfo.ucCurPinCounter))
			'UPGRADE_WARNING: Couldn't resolve default property of object AccessToString(). Click for more: 'ms-help://MS.VSCC.v80/dv_commoner/local/redirect.htm?keyword="6A50421D-15FE-4896-8A1B-2EC21E9037B2"'
			ShowResult("Create access ........... : " & AccessToString((epsAccessInfo.ucCreateAccess)))
			'UPGRADE_WARNING: Couldn't resolve default property of object AccessToString(). Click for more: 'ms-help://MS.VSCC.v80/dv_commoner/local/redirect.htm?keyword="6A50421D-15FE-4896-8A1B-2EC21E9037B2"'
			ShowResult("Delete access ........... : " & AccessToString((epsAccessInfo.ucDeleteAccess)))
		End If
		
		'Get capablities
        epsCapabilityStr = ePass.GetProperty(EPAS_PROP_CAPABILITIES, " ", 128)
		'UPGRADE_WARNING: Couldn't resolve default property of object CheckOP(Get capabilities). Click for more: 'ms-help://MS.VSCC.v80/dv_commoner/local/redirect.htm?keyword="6A50421D-15FE-4896-8A1B-2EC21E9037B2"'
		If False = CheckOP("Get capabilities") Then
			'UPGRADE_WARNING: Couldn't resolve default property of object GetDeviceInfo. Click for more: 'ms-help://MS.VSCC.v80/dv_commoner/local/redirect.htm?keyword="6A50421D-15FE-4896-8A1B-2EC21E9037B2"'
			GetDeviceInfo = False
			Exit Function
		Else
		End If
        'ByteArrayToLong(epsCapability, Prop)
		'UPGRADE_WARNING: Couldn't resolve default property of object CapabilitiesToString(). Click for more: 'ms-help://MS.VSCC.v80/dv_commoner/local/redirect.htm?keyword="6A50421D-15FE-4896-8A1B-2EC21E9037B2"'
        ShowResult("Capabilities ............ : " & epsCapabilityStr) 'CapabilitiesToString(epsCapability))
		'UPGRADE_WARNING: Couldn't resolve default property of object GetDeviceInfo. Click for more: 'ms-help://MS.VSCC.v80/dv_commoner/local/redirect.htm?keyword="6A50421D-15FE-4896-8A1B-2EC21E9037B2"'
		GetDeviceInfo = True
	End Function
	
	'Check whether an operation successful.
	Private Function CheckOP(ByRef Info As String) As Object
		If Err.Number Then
			Info = Info & " failed."
			ShowError((Info))
			Err.Clear() 'Clear the global error flag
			'UPGRADE_WARNING: Couldn't resolve default property of object CheckOP. Click for more: 'ms-help://MS.VSCC.v80/dv_commoner/local/redirect.htm?keyword="6A50421D-15FE-4896-8A1B-2EC21E9037B2"'
			CheckOP = False
		Else
			Info = Info & " successful."
			ShowHint(Info)
			'UPGRADE_WARNING: Couldn't resolve default property of object CheckOP. Click for more: 'ms-help://MS.VSCC.v80/dv_commoner/local/redirect.htm?keyword="6A50421D-15FE-4896-8A1B-2EC21E9037B2"'
			CheckOP = True
		End If
	End Function
	
	Private Sub btnClearInfo_Click(ByVal eventSender As System.Object, ByVal eventArgs As System.EventArgs) Handles btnClearInfo.Click
		txtInfo.SelectionStart = 0
		txtInfo.SelectionLength = Len(txtInfo.Text)
		txtInfo.SelectedText = ""
	End Sub
	
	Private Sub btnCryptoDemo_Click(ByVal eventSender As System.Object, ByVal eventArgs As System.EventArgs) Handles btnCryptoDemo.Click
		On Error Resume Next
		Dim Info As String
		Dim lWritten As Integer
		Dim i As Integer
		
		Dim strRnd As String
		Dim strAuthKey As String
		Dim strKey1 As String
		Dim strKey2 As String
		Dim strSoftDigest As String
		Dim strePassDigest As String
		
		Dim RndArray(19) As Byte
		Dim Key1Array(15) As Byte
		Dim Key2Array(15) As Byte
		Dim SoftDigest(15) As Byte
		Dim ePassDigest(15) As Byte
		
		Dim bComp As Boolean
		
		' Set "FeiTian" as the user's key
		strAuthKey = "FeiTian"
		
		ShowInfo(System.Drawing.ColorTranslator.ToOle(System.Drawing.Color.Magenta), "")
		ShowInfo(System.Drawing.ColorTranslator.ToOle(System.Drawing.Color.Magenta), "===================================================")
		ShowInfo(System.Drawing.ColorTranslator.ToOle(System.Drawing.Color.Magenta), "Domonstraction for cryptographic operation function")
		ShowInfo(System.Drawing.ColorTranslator.ToOle(System.Drawing.Color.Magenta), "===================================================")
		
		'Create a directory for demonstration
        CreateDemoDir(&H200)
		CheckOP("CreateDemoDir")
		
		'Create two key file.
        HASH.MD5HMAC("", strAuthKey, strKey1, strKey2, strSoftDigest)
		CheckOP("Hash MD5_HMAC by software")
		
		StringToHex(Key1Array, strKey1, 16)
		StringToHex(Key2Array, strKey2, 16)
		
		ShowResult("First key file")
		ShowByteArray(Key1Array, 16)
		ShowResult("Second key file")
		ShowByteArray(Key2Array, 16)
		
		'Create two key file and save the key-information
		'The ID of first key-file is &H1234 and
		'the ID of second key-file is &H2345
		epsFileInfo.lID = &H1234s 'ID of first key file
		epsFileInfo.lFileSize = 16 'A key file just need 16 bytes
		epsFileInfo.ucFileType = EPAS_FILETYPE_KEY
		epsFileInfo.ucReadAccess = EPAS_ACCESS_NONE
		epsFileInfo.ucWriteAccess = EPAS_ACCESS_ANYONE
		epsFileInfo.ucCryptAccess = EPAS_ACCESS_ANYONE
		
		ePass.CreateFile(0, epsFileInfo)
		CheckOP("Create first key file")
		
        ePass.Write(0, 0, Key1Array, 16, lWritten)
		CheckOP("Save to first key file")
		
		epsFileInfo.lID = &H2345s 'ID of first key file
		epsFileInfo.lFileSize = 16 'A key file just need 16 bytes
		epsFileInfo.ucFileType = EPAS_FILETYPE_KEY
		epsFileInfo.ucReadAccess = EPAS_ACCESS_NONE
		epsFileInfo.ucWriteAccess = EPAS_ACCESS_ANYONE
		epsFileInfo.ucCryptAccess = EPAS_ACCESS_ANYONE
		
		ePass.CreateFile(0, epsFileInfo)
		CheckOP("Create second key file")
		
		ePass.Write(0, 0, Key2Array, 16, lWritten)
		CheckOP("Save to second key file")
		
		'Create some random data for MD5_HMAC compute.
		'You should create random data in your way.
		'Here I create a string with 20 random char.
		Randomize()
		strRnd = ""
		For i = 0 To 19
			'strRnd = strRnd + Chr(Int((Asc("z") - Asc("A")) * Rnd + Asc("A")))
			strRnd = strRnd & Chr((127 - 32) * Rnd() + 32)
		Next i
		StringToByteArray(RndArray, strRnd, Len(strRnd))
		
		'Do MD5_HMAC by software
		HASH.MD5HMAC(strRnd, strAuthKey, strKey1, strKey2, strSoftDigest)
		StringToHex(SoftDigest, strSoftDigest, 16)
		ShowHint("MD5_HMAC compute by software successful.")
		ShowByteArray(SoftDigest, 16)
		
		'Do MD5_HMAC by ePass
        'ePass.MD5HMAC(&H1234s, &H2345s, CStr(RndArray(0)), Len(strRnd), ePassDigest(0))
        ePass.MD5HMAC(&H1234S, &H2345S, strRnd, Len(strRnd), strePassDigest)
        CheckOP("MD5_HMAC compute by ePass")
        StringToHex(ePassDigest, strePassDigest, 16)

		ShowByteArray(ePassDigest, 16)

		bComp = True
		For i = 0 To 15
			If ePassDigest(i) <> SoftDigest(i) Then
				bComp = False
				Exit For
			End If
		Next i
		
		If bComp = True Then
			ShowResult("Verify passed.")
		Else
			ShowResult("Verify failed.")
		End If
		
		
		'Remove the demo-directory
        RemoveDemoDir(&H200)
		
		ShowInfo(System.Drawing.ColorTranslator.ToOle(System.Drawing.Color.Magenta), "======= End of Cryptographic Demonstration ========")
	End Sub
	
	Private Sub btnDeviceDemo_Click(ByVal eventSender As System.Object, ByVal eventArgs As System.EventArgs) Handles btnDeviceDemo.Click
		On Error Resume Next
		
		Dim Info As String
		
		ShowInfo(System.Drawing.ColorTranslator.ToOle(System.Drawing.Color.Magenta), "")
		ShowInfo(System.Drawing.ColorTranslator.ToOle(System.Drawing.Color.Magenta), "=============================================")
		ShowInfo(System.Drawing.ColorTranslator.ToOle(System.Drawing.Color.Magenta), "Domonstraction for device management function")
		ShowInfo(System.Drawing.ColorTranslator.ToOle(System.Drawing.Color.Magenta), "=============================================")
		'Open the first device to demonstration
		ePass.OpenDevice(EPAS_OPEN_FIRST, VariantType.Empty)
		'UPGRADE_WARNING: Couldn't resolve default property of object CheckOP(Open first device). Click for more: 'ms-help://MS.VSCC.v80/dv_commoner/local/redirect.htm?keyword="6A50421D-15FE-4896-8A1B-2EC21E9037B2"'
		If False = CheckOP("Open first device") Then
			Exit Sub
		Else
			btnFileDemo.Enabled = True
			btnCryptoDemo.Enabled = True
		End If
		
		'UPGRADE_WARNING: Couldn't resolve default property of object GetDeviceInfo(). Click for more: 'ms-help://MS.VSCC.v80/dv_commoner/local/redirect.htm?keyword="6A50421D-15FE-4896-8A1B-2EC21E9037B2"'
		If False = GetDeviceInfo() Then
			Exit Sub
		End If
		
		ShowInfo(System.Drawing.ColorTranslator.ToOle(System.Drawing.Color.Magenta), "======== End of Device Demonstration ========")
	End Sub
	
	Private Sub btnFileDemo_Click(ByVal eventSender As System.Object, ByVal eventArgs As System.EventArgs) Handles btnFileDemo.Click
		On Error Resume Next
		Dim Info As String
		
		Dim demoStr As String
		Dim demoStrArray(&H20s - 1) As Byte
		Dim lWritten As Integer
		Dim lRead As Integer
		
		ShowInfo(System.Drawing.ColorTranslator.ToOle(System.Drawing.Color.Magenta), "")
		ShowInfo(System.Drawing.ColorTranslator.ToOle(System.Drawing.Color.Magenta), "========================================================")
		ShowInfo(System.Drawing.ColorTranslator.ToOle(System.Drawing.Color.Magenta), "Domonstraction for directory and file operation function")
		ShowInfo(System.Drawing.ColorTranslator.ToOle(System.Drawing.Color.Magenta), "========================================================")
		
		'Create a directory for demonstration
        CreateDemoDir(&H400)
		
		'Create a file for demonstration
		epsFileInfo.lID = &H32F5s 'Create a file which ID is 0x32F5.
		epsFileInfo.lFileSize = &H20s 'Size of demo-file set to 0x20 (32 bytes).
		epsFileInfo.lFlags = 0
		epsFileInfo.ucFileType = EPAS_FILETYPE_DATA
		epsFileInfo.ucReadAccess = EPAS_ACCESS_ANYONE
		epsFileInfo.ucWriteAccess = EPAS_ACCESS_ANYONE
		epsFileInfo.ucCryptAccess = EPAS_ACCESS_ANYONE
		ePass.CreateFile(0, epsFileInfo)
		CheckOP("Create a file for demo")
		
		'Write something to the demo-file.
		demoStr = "This is a demo for VB."
		StringToByteArray(demoStrArray, demoStr, Len(demoStr))
        ePass.Write(0, 0, demoStrArray, Len(demoStr), lWritten)
		CheckOP("Write something to the demo-file")
		ShowResult(CStr(lWritten) & " bytes written.")
		
		'Close the demo-file.
		ePass.CloseFile()
		CheckOP("Close the demo-file")
		
		'Re-open the demo-file.
		ePass.OpenFile(0, &H32F5s, epsFileInfo)
		CheckOP("Re-open the demo-file")
		
		'Read from the dmeo-file.
        demoStrArray = ePass.Read(0, 0, epsFileInfo.lFileSize, lRead)
		CheckOP("Read from the demo-file")
		ShowResult(CStr(lRead) & " bytes read.")
		ByteArrayToString(demoStr, demoStrArray, lRead)
		ShowResult("READ: " & demoStr)
		
		'Remove the demo-file.
		ePass.DeleteFile(0, &H32F5s)
		CheckOP("Remove the demo-file")
		
		'Remove the demo-directory.
        RemoveDemoDir(&H400)
		
		ShowInfo(System.Drawing.ColorTranslator.ToOle(System.Drawing.Color.Magenta), "========= End of File Demonstration =========")
	End Sub
	
	Private Sub frmMain_Load(ByVal eventSender As System.Object, ByVal eventArgs As System.EventArgs) Handles MyBase.Load
		Dim LibVersion As Integer
		Dim DriverVersion As Integer
		Dim Info As String
		
		'Initialize the guid array.
		epsGUID(0) = &H3Fs
		epsGUID(1) = &H85s
		epsGUID(2) = &H28s
		epsGUID(3) = &HBs
		
		epsGUID(4) = &HC1s
		epsGUID(5) = &HE4s
		
		epsGUID(6) = &HDEs
		epsGUID(7) = &H4As
		
		epsGUID(8) = &HACs
		epsGUID(9) = &H61s
		epsGUID(10) = &HA6s
		epsGUID(11) = &H6s
		epsGUID(12) = &H2Es
		epsGUID(13) = &HA8s
		epsGUID(14) = &HF0s
		epsGUID(15) = &H99s
		
		epsStrAppName = "ePass_VB_DEMO"
		StringToByteArray(epsAppName, epsStrAppName, Len(epsStrAppName))
		
		txtInfo.SelectionStart = 0
		txtInfo.SelectionColor = System.Drawing.Color.Red
		txtInfo.SelectedText = "===========================================" & Chr(13)
		txtInfo.SelectedText = " ePass new SDK (2.0) function test program" & Chr(13)
		txtInfo.SelectedText = "        By Water Bird. 05-31-2001" & Chr(13)
		txtInfo.SelectedText = "       Feitian Technology Co., Ltd." & Chr(13)
		txtInfo.SelectedText = "===========================================" & Chr(13) & Chr(13)
		
		LibVersion = ePass.GetLibVersion
		CheckOP("Get ePass library version")
		VersionToString(LibVersion, Info)
		ShowResult("Library version : " & Info)
		
		DriverVersion = ePass.GetDriverVersion
		CheckOP("Get ePass driver version")
		VersionToString(DriverVersion, Info)
		ShowResult("Driver version : " & Info)
		
		ePass.CreateContext(0, EPAS_API_VERSION)
		CheckOP("Create ePass device context handle")
		
	End Sub
	
	Private Sub frmMain_FormClosed(ByVal eventSender As System.Object, ByVal eventArgs As System.Windows.Forms.FormClosedEventArgs) Handles Me.FormClosed
		ePass.CloseDevice()
		ePass.DeleteContext()
	End Sub

    Private Sub ePass_Enter(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles ePass.Enter

    End Sub
End Class