Option Strict Off
Option Explicit On
Module modePs1000
	
	'Public varibles
    Public epsSerialNum(7) As Byte
    Public epsSerialNumStr As String
    Public epsFriendlyName As String
    Public epsCapability As Integer
    Public epsCapabilityStr As String
	Public epsMemSize As Integer
	Public epsAccessInfo As ePasModLib.WAccessInfo
	Public epsVersionInfo As ePasModLib.WVersionInfo
	Public epsSysInfo As ePasModLib.WSysInfo
	Public epsFileInfo As ePasModLib.WFileInfo
	Public epsDirInfo As ePasModLib.WDirInfo
	
	'Const defined by Feitian Tech.
	
	'Public Const EPAS_MAX_LEVEL = &H8
	
	Public Const EPAS_APP_NAME_SIZE As Short = &H20s
	Public Const EPAS_FRIENDLY_NAME_SIZE As Short = &H20s
	
	Public Const EPAS_NULL As Short = &H0s
	Public Const EPAS_API_VERSION As Short = &H200s
	
	Public Const EPAS_OPEN_NEXT As Short = &H0s
	Public Const EPAS_OPEN_FIRST As Short = &H1s
	Public Const EPAS_OPEN_CURRENT As Short = &H2s
	Public Const EPAS_OPEN_SPECIFIC As Short = &H3s
	Public Const EPAS_OPEN_MASK As Short = &H7s
	Public Const EPAS_OPEN_BY_NAME As Short = &H100s
	Public Const EPAS_OPEN_BY_GUID As Short = &H200s
	
	Public Const EPAS_CONFIG_DES_KEY_SIZE As Short = &H1s
	Public Const EPAS_CONFIG_RSA_MOD_SIZE As Short = &H2s
	
	Public Const EPAS_PROP_CAPABILITIES As Short = &H0s
	Public Const EPAS_PROP_MEM_SIZE As Short = &H1s
	'Public Const EPAS_PROP_ROOT_ACCESSINFO = &H2
	Public Const EPAS_PROP_ACCESSINFO As Short = &H3s
	Public Const EPAS_PROP_APP_NAME As Short = &H4s
	Public Const EPAS_PROP_APP_GUID As Short = &H5s
	Public Const EPAS_PROP_VERSIONINFO As Short = &H6s
	Public Const EPAS_PROP_SERNUM As Short = &H7s
	Public Const EPAS_PROP_LED_ON As Short = &H8s
	Public Const EPAS_PROP_LED_OFF As Short = &H9s
	Public Const EPAS_PROP_CONFIGURATION As Short = &HAs
	Public Const EPAS_PROP_FRIENDLY_NAME As Short = &HBs
	
	Public Const EPAS_ROOT_DIR As Short = &H0s
	Public Const EPAS_7816_ROOT_DIR As Short = &H3F00s
	Public Const EPAS_AUTO_ID_BASE As Short = &HF000s
	Public Const EPAS_INDEX_FILE As Short = &HFFFFs
	Public Const EPAS_TOKEN_NAME_FILE As Short = &HFFFEs
	
	Public Const EPAS_DIR_BY_ID As Short = &H100s
	Public Const EPAS_DIR_BY_LONG_ID As Short = &H200s
	Public Const EPAS_DIR_BY_NAME As Short = &H300s
	Public Const EPAS_DIR_BY_GUID As Short = &H400s
	Public Const EPAS_DIR_BY_MASK As Short = &HF00s
	
	Public Const EPAS_FILETYPE_UNUSED As Short = &H0s
	Public Const EPAS_FILETYPE_DIR As Short = &H1s
	Public Const EPAS_FILETYPE_DATA As Short = &H2s
	Public Const EPAS_FILETYPE_COUNTER As Short = &H3s
	Public Const EPAS_FILETYPE_KEY As Short = &H4s
	Public Const EPAS_FILETYPE_UNKNOWN As Short = &HFFs
	
	Public Const EPAS_ACCESS_ANYONE As Short = &H0s
	Public Const EPAS_ACCESS_USER As Short = &H1s
	Public Const EPAS_ACCESS_OFFICER As Short = &H2s
	Public Const EPAS_ACCESS_APP As Short = &H3s
	Public Const EPAS_ACCESS_NONE As Short = &H7s
	
	Public Const EPAS_ACCESS_READ As Short = &H1s
	Public Const EPAS_ACCESS_WRITE As Short = &H2s
	Public Const EPAS_ACCESS_CRYPT As Short = &H4s
	
	Public Const EPAS_CAPS_MD5HMAC As Short = &H1s
	'Public Const EPAS_CAPS_MD5XOR = &H2
	'Public Const EPAS_CAPS_MD5CHAP = &H4
	'Public Const EPAS_CAPS_DES = &H8
	'Public Const EPAS_CAPS_APPAUTH = &H20
	
	Public Const EPAS_DIR_FROM_MF As Short = &H0s
	Public Const EPAS_DIR_FROM_CUR_DF As Short = &H10s
	Public Const EPAS_DIR_TO_PARENT As Short = &H20s
	
	Public Const EPAS_FILE_READ As Short = &H10s
	Public Const EPAS_FILE_WRITE As Short = &H20s
	Public Const EPAS_FILE_CRYPT As Short = &H40s
	
	Public Const EPAS_CREATE_AUTO_ID As Integer = &H10000
	
	Public Const EPAS_DELETE_RECURSIVE As Integer = &H10000
	
	Public Const EPAS_VERIFY_USER_PIN As Short = &H0s
	Public Const EPAS_VERIFY_SO_PIN As Short = &H1s
	Public Const EPAS_VERIFY_APPKEY As Short = &H2s
	Public Const EPAS_VERIFY_NO_HASH As Short = &H1000s
	Public Const EPAS_VERIFY_HASH_UPIN As Short = &H2000s
	
	Public Const EPAS_CHANGE_USER_PIN As Short = &H0s
	Public Const EPAS_UNBLOCK_USER_PIN As Short = &H1s
	Public Const EPAS_CHANGE_SO_PIN As Short = &H2s
	Public Const EPAS_CHANGE_APP_KEY As Short = &H3s
	Public Const EPAS_CHANGE_MASK As Short = &HFs
	Public Const EPAS_CHANGE_NO_HASH As Short = &H1000s
	Public Const EPAS_CHANGE_HASH_UPIN As Short = &H2000s
	
	Public Const EPAS_SCOPE_MF As Short = &H0s
	Public Const EPAS_SCOPE_DF As Short = &H1s
	
	Public Const EPAS_HASH_MD5_XOR As Short = &H0s
	Public Const EPAS_HASH_MD5_HMAC As Short = &H1s
	Public Const EPAS_HASH_MD5_CHAP As Short = &H2s
	Public Const EPAS_HASH_DES_MAC As Short = &H10s
	Public Const EPAS_HASH_TYPE_MASK As Short = &HFFs
	
	Public Const EPAS_CRYPT_DES As Short = &H0s
	Public Const EPAS_CRYPT_TYPE_MASK As Short = &HFFs
	
	Public Const EPAS_GENKEY_ENCRYPT As Short = &H100s
	Public Const EPAS_GENKEY_CREATE As Short = &H200s
	Public Const EPAS_DES_ENCRYPT As Short = &H80s
	Public Const EPAS_DES_DECRYPT As Short = &H40s
	
	Public Const FT_SUCCESS As Short = &H0s
	Public Const FT_CANNOT_OPEN_DRIVER As Short = &H1s '&H80100001
	Public Const FT_INVALID_DRVR_VERSION As Short = &H2s '&H80100002
	Public Const FT_INVALID_COMMAND As Short = &H3s
	Public Const FT_ACCESS_DENIED As Short = &H4s
	Public Const FT_ALREADY_ZERO As Short = &H5s
	Public Const FT_UNIT_NOT_FOUND As Short = &H6s
	Public Const FT_DEVICE_REMOVED As Short = &H7s
	Public Const FT_COMMUNICATIONS_ERROR As Short = &H8s
	Public Const FT_DIR_NOT_FOUND As Short = &H9s
	Public Const FT_FILE_NOT_FOUND As Short = &HAs '&H8010000A
	Public Const FT_MEM_CORRUPT As Short = &HBs
	Public Const FT_INTERNAL_HW_ERROR As Short = &HCs
	Public Const FT_INVALID_RESP_SIZE As Short = &HDs
	Public Const FT_PIN_EXPIRED As Short = &HEs
	Public Const FT_ALREADY_EXISTS As Short = &HFs
	Public Const FT_NOT_ENOUGH_MEMORY As Short = &H10s
	Public Const FT_INVALID_PARAMETER As Short = &H11s
	Public Const FT_INPUT_TOO_LONG As Short = &H13s
	Public Const FT_INVALID_FILE_SELECTED As Short = &H14s
	Public Const FT_DEVICE_IN_USE As Short = &H15s
	Public Const FT_INVALID_API_VERSION As Short = &H16s
	Public Const FT_TIME_OUT_ERROR As Short = &H17s
	Public Const FT_ITEM_NOT_FOUND As Short = &H18s
	Public Const FT_COMMAND_ABORTED As Short = &H19s
	Public Const FT_INVALID_STATUS As Short = &HFFs
	
	'UPGRADE_NOTE: str was upgraded to str_Renamed. Click for more: 'ms-help://MS.VSCC.v80/dv_commoner/local/redirect.htm?keyword="A9E4979A-37FA-4718-9994-97DD76ED70A7"'
	Public Sub StringToByteArray(ByRef ByteArray() As Byte, ByRef str_Renamed As String, ByRef lSize As Integer)
		Dim i As Integer
		Dim S As String
		
		S = str_Renamed
		For i = 0 To lSize - 1
			If Len(S) <> 0 Then
				ByteArray(i) = Asc(S)
				S = Right(S, Len(S) - 1)
			Else
				ByteArray(i) = 0
			End If
		Next i
	End Sub
	
	'UPGRADE_NOTE: str was upgraded to str_Renamed. Click for more: 'ms-help://MS.VSCC.v80/dv_commoner/local/redirect.htm?keyword="A9E4979A-37FA-4718-9994-97DD76ED70A7"'
	Public Sub ByteArrayToString(ByRef str_Renamed As String, ByRef ByteArray() As Byte, ByRef lSize As Integer)
		Dim i As Integer
		
		str_Renamed = ""
		For i = 0 To lSize - 1
			If ByteArray(i) <> 0 Then
				str_Renamed = str_Renamed & Chr(ByteArray(i))
			End If
		Next i
	End Sub
	
	'UPGRADE_NOTE: str was upgraded to str_Renamed. Click for more: 'ms-help://MS.VSCC.v80/dv_commoner/local/redirect.htm?keyword="A9E4979A-37FA-4718-9994-97DD76ED70A7"'
	Public Sub HexToString(ByRef ByteArray() As Byte, ByRef str_Renamed As String, ByRef lSize As Integer)
		Dim b As Byte
		Dim i As Integer
		
		For i = lSize - 1 To 0 Step -1
			b = ByteArray(i) \ 16
			If b > 9 Then
				str_Renamed = str_Renamed & Chr(b + Asc("A") - 10)
			Else
				str_Renamed = str_Renamed & Chr(b + Asc("0"))
			End If
			
			b = ByteArray(i) Mod 16
			If b > 9 Then
				str_Renamed = str_Renamed & Chr(b + Asc("A") - 10)
			Else
				str_Renamed = str_Renamed & Chr(b + Asc("0"))
			End If
		Next i
	End Sub
	
	'UPGRADE_NOTE: str was upgraded to str_Renamed. Click for more: 'ms-help://MS.VSCC.v80/dv_commoner/local/redirect.htm?keyword="A9E4979A-37FA-4718-9994-97DD76ED70A7"'
	Public Sub StringToHex(ByRef ByteArray() As Byte, ByRef str_Renamed As String, ByRef lSize As Integer)
		Dim b As Byte
		Dim i As Integer
		Dim S As String
		
		For i = 0 To lSize - 1
			ByteArray(i) = 0
		Next i
		
		If Left(str_Renamed, 2) = "&H" Then
			S = UCase(Right(str_Renamed, Len(str_Renamed) - 2))
		Else
			S = UCase(str_Renamed)
		End If
		
		For i = 0 To lSize - 1
			If Len(S) = 0 Then
				Exit For
			End If
			
			b = Asc(S)
			If b > 64 And b < 71 Then
				ByteArray(i) = b - 65 + 10
			ElseIf b > 47 And b < 58 Then 
				ByteArray(i) = b - 48
			End If
			
			ByteArray(i) = ByteArray(i) * 16
			S = Right(S, Len(S) - 1)
			If Len(S) = 0 Then
				Exit For
			End If
			
			b = Asc(S)
			If b > 64 And b < 71 Then
				ByteArray(i) = b - 65 + 10 + ByteArray(i)
			ElseIf b > 47 And b < 58 Then 
				ByteArray(i) = b - 48 + ByteArray(i)
			End If
			
			S = Right(S, Len(S) - 1)
			If Len(S) = 0 Then
				Exit For
			End If
		Next i
	End Sub
	
	Public Sub ByteArrayToLong(ByRef lRet As Integer, ByRef ByteArray() As Byte)
		Dim S As String
		Dim M As String
		
		S = "&H"
		
		M = Hex(ByteArray(3))
		If Len(M) < 2 Then
			S = S & "0"
		End If
		S = S & M
		
		M = Hex(ByteArray(2))
		If Len(M) < 2 Then
			S = S & "0"
		End If
		S = S & M
		
		M = Hex(ByteArray(1))
		If Len(M) < 2 Then
			S = S & "0"
		End If
		S = S & M
		
		M = Hex(ByteArray(0))
		If Len(M) < 2 Then
			S = S & "0"
		End If
		S = S & M
		
		lRet = Val(S)
	End Sub
	Public Sub LongToByteArray(ByRef ByteArray() As Byte, ByRef l As Integer)
		Dim S As String
		Dim M As String
		
		ByteArray(0) = ByteArray(1) = ByteArray(2) = ByteArray(3) = 0
		S = Hex(l)
		
		M = Right(S, 2)
		ByteArray(0) = Val("&H" & M)
		
		If Len(S) > 2 Then
			S = Left(S, Len(S) - 2)
			M = Right(S, 2)
			ByteArray(1) = Val("&H" & M)
		End If
		
		If Len(S) > 2 Then
			S = Left(S, Len(S) - 2)
			M = Right(S, 2)
			ByteArray(2) = Val("&H" & M)
		End If
		
		If Len(S) > 2 Then
			S = Left(S, Len(S) - 2)
			M = Right(S, 2)
			ByteArray(3) = Val("&H" & M)
		End If
	End Sub
	
	Public Sub VersionToString(ByRef Version As Integer, ByRef Info As String)
		Dim Major As Byte
		Dim Minor As Byte
		Dim Build As Short
		Dim S As String
		Dim M As String
		
		Major = Minor = Build = 0
		S = Hex(Version)
		
		M = Right(S, 4)
		Build = Val("&H" & M)
		
		If Len(S) > 4 Then
			S = Left(S, Len(S) - 4)
			M = Right(S, 2)
			Minor = Val("&H" & M)
		End If
		
		If Len(S) > 2 Then
			S = Left(S, Len(S) - 2)
			M = Right(S, 2)
			Major = Val("&H" & M)
		End If
		
		Info = CStr(Major) & "." & CStr(Minor) & "." & CStr(Build)
	End Sub
End Module