/*
[]=================================================================[]
	FileDemo.cpp

	Copyright (C) 2001 Feitian Tech. Co. Ltd. All rights reserved.
	by Water Bird
	Created at 17-5-2001   11:25

	Comment : 
[]=================================================================[]
*/

#include <Windows.h>
#include <Stdio.h>
#include <conio.h>
#include "FileDemo.h"
#include "../common/eps1kDemo.h"
#include "../common/eps1kUtility.h"

#define DEMO_FILE_ID 0xEF03
#define DEMO_FILE_SIZE 50

// Global varible.

int
main(void)
{
    EPAS_STATUS epsRet;
    EPAS_HANDLE handle;
	unsigned char pBuf[DEMO_FILE_SIZE];
	//EPAS_FILEINFO fi;

	ZeroMemory(pBuf, DEMO_FILE_SIZE);

	ShowDemoTitle();

    epsRet = epas_CreateContext(
        &handle,
        0,
        EPAS_API_VERSION
        );
	if (CheckOP(epsRet, "Create context handle"))
	{
		// Find an unused device and open it.
		epsRet = OpenAnUnusedDevice(handle);
		if (!CheckOP(epsRet, "Find an unused device and opened"))
		{
			epas_DeleteContext(handle);
			return (1);
		}
		
		// Create a file for demo.
		CreateDemoFile(handle);
		
		// Get user input
		GetUserInput(pBuf, DEMO_FILE_SIZE);

		// Write user input to demo file
		WriteToDemoFile(handle, pBuf);

		// Close the demo file.
		epsRet = epas_CloseFile(handle);
		CheckOP(epsRet, "Close file");

		// Open the demo file, read all data and show them.
		ReadFromDemoFile(handle);

		// Delete the demo file.
		DeleteDemoFile(handle);

		// Close the device.
		epsRet = epas_CloseDevice(handle);
		CheckOP(epsRet, "Close device");
		// Free the context handle.
		epsRet = epas_DeleteContext(handle);
		CheckOP(epsRet, "Delete context handle");
		return (0);
	}
	else
		return (1);
}

/*
 *	CreateFile() routine create a file which ID set to 0xEF03,
 *  and set it's size to 50 bytes, everyone can read/write/crypt
 *  this file.
 */
void
CreateDemoFile(EPAS_HANDLE handle)
{
	EPAS_STATUS epsRet;
	EPAS_FILEINFO fi;

	ZeroMemory(&fi,sizeof(EPAS_FILEINFO));

	fi.ulID = 0xEF03;
	fi.ucFileType = EPAS_FILETYPE_DATA;
	fi.ulFileSize = 50;
	fi.ucReadAccess = EPAS_ACCESS_ANYONE;
	fi.ucWriteAccess = EPAS_ACCESS_ANYONE;
	fi.ucCryptAccess = EPAS_ACCESS_ANYONE;

	epsRet = epas_CreateFile(
		handle,
		0,
		&fi,
		sizeof(EPAS_FILEINFO)
		);
	CheckOP(epsRet, "Create demo file");
} // End of CreateDemoFile().

/*
 *	WriteToFile() routine write some data special by
 *  pBuf to a file.
 */
void
WriteToDemoFile(EPAS_HANDLE handle, unsigned char* pBuf)
{
	EPAS_STATUS epsRet;
	unsigned long ulWritten;

	epsRet = epas_Write(
		handle,
		0,
		0,
		pBuf,
		DEMO_FILE_SIZE,
		&ulWritten
		);
	CheckOP(epsRet, "Write to demo file");
} // End of WriteToDemoFile().

/*
 *	ReadFromFile() routine open a file and read all data,
 *  At last, I'll show the data for you.
 */
void
ReadFromDemoFile(EPAS_HANDLE handle)
{
	EPAS_STATUS epsRet;
	EPAS_FILEINFO fi;
	unsigned char* pBuf;
	unsigned long ulReaded;

	// First, you must open the file and get the information
	// of it.

	epsRet = epas_OpenFile(
		handle,
		0,
		DEMO_FILE_ID,
		&fi,
		sizeof(EPAS_FILEINFO)
		);
	if (CheckOP(epsRet, "Open file"))
	{
		pBuf = (unsigned char*) LocalAlloc(LMEM_FIXED | LMEM_ZEROINIT, fi.ulFileSize);
		if (pBuf)
		{
			epsRet = epas_Read(
				handle,
				0,
				0,
				pBuf,
				fi.ulFileSize,
				&ulReaded
				);
			if (CheckOP(epsRet, "Read data from file"))
			{
				// Show the data.
				printf("\nContext of the file:");
				printf("\n-------------------------------------------\n");
				ShowData(pBuf, ulReaded);
				printf("\n-------------------------------------------\n");
			}

			// Rememober to free the memory when not needed.
			LocalFree(pBuf);
		}
		else
			printf("Can't alloc memory for read-buffer.\n");
	}
} // End of ReadFromDemoFile().

/*
 *	DeleteFile() routine remove the demo file.
 */
void
DeleteDemoFile(EPAS_HANDLE handle)
{
	EPAS_STATUS epsRet;

	epsRet = epas_DeleteFile(
		handle,
		0,
		DEMO_FILE_ID
		);
	CheckOP(epsRet, "Delete file");
} // End of DeleteDemoFile().

