
#include "stdafx.h"
#include "ShellExt.h"
#include "EncFile.h"


//
//  FUNCTION: CShellExt::QueryContextMenu(HMENU, UINT, UINT, UINT, UINT)
//
//  PURPOSE: Called by the shell just before the context menu is displayed.
//           This is where you add your specific menu items.
//
//  PARAMETERS:
//    hMenu      - Handle to the context menu
//    indexMenu  - Index of where to begin inserting menu items
//    idCmdFirst - Lowest value for new menu ID's
//    idCmtLast  - Highest value for new menu ID's
//    uFlags     - Specifies the context of the menu event
//
//  RETURN VALUE:
//
//
//  COMMENTS:
//

STDMETHODIMP CShellExt::QueryContextMenu(HMENU hMenu,
                                         UINT indexMenu,
                                         UINT idCmdFirst,
                                         UINT idCmdLast,
                                         UINT uFlags)
{
    UINT idCmd = idCmdFirst;
    char szMenuText1[64]="Encrypt (from ePass1000 Sample)";
	char szMenuText2[64]="Decrypt (from ePass1000 Sample)";
	char* pMenuText=NULL;    
	BOOL bAppendItems=TRUE;
	
	if(m_bEncryptMode)
	{
		pMenuText = szMenuText1;
	}
	else
	{
		pMenuText = szMenuText2;
	}	

    if ((uFlags & 0x000F) == CMF_NORMAL)  //Check == here, since CMF_NORMAL=0
    {		//normal state
        
    }
    else
        if (uFlags & CMF_VERBSONLY)
        {	//Shortcut File
            
        }
    else
        if (uFlags & CMF_EXPLORE)
        {	//right click in Explorer
            
        }
    else
        if (uFlags & CMF_DEFAULTONLY)
        {
            bAppendItems = FALSE;
        }
    else
        {
            char szTemp[32];

            wsprintf(szTemp, "uFlags==>%d\r\n", uFlags);
            bAppendItems = FALSE;
        }

    if (bAppendItems)
    {
        InsertMenu(hMenu, indexMenu++, MF_SEPARATOR|MF_BYPOSITION, 0, NULL);
        
        InsertMenu(hMenu,
                   indexMenu,
                   MF_STRING|MF_BYPOSITION,
                   idCmd++,
                   pMenuText);

		/*MENUITEMINFO  mi;
		mi.cbSize = sizeof(MENUITEMINFO);
		mi.fMask = MIIM_STATE;
		mi.fState = MFS_HILITE;
		SetMenuItemInfo(hMenu,indexMenu,TRUE,&mi);*/

        return ResultFromShort(idCmd-idCmdFirst); //Must return number of menu
												  //items we added.
   }

   return NOERROR;
}

//
//  FUNCTION: CShellExt::InvokeCommand(LPCMINVOKECOMMANDINFO)
//
//  PURPOSE: Called by the shell after the user has selected on of the
//           menu items that was added in QueryContextMenu().
//
//  PARAMETERS:
//    lpcmi - Pointer to an CMINVOKECOMMANDINFO structure
//
//  RETURN VALUE:
//
//
//  COMMENTS:
//

HANDLE g_hEventOk=NULL;

DWORD WINAPI EncryptTProc( LPVOID lpParameter)
{
	char* pSrcFileName  =(char*)lpParameter;
	char  pFileName[512];

	strcpy(pFileName,pSrcFileName);
	
	EF_Encrypt(pFileName);
	SetEvent(g_hEventOk);
	return 0;
}

DWORD WINAPI DecryptTProc( LPVOID lpParameter)
{
	char* pSrcFileName  =(char*)lpParameter;
	char  pFileName[512];

	strcpy(pFileName,pSrcFileName);
	
	EF_Decrypt(pFileName);
	SetEvent(g_hEventOk);
	return 0;
}

STDMETHODIMP CShellExt::InvokeCommand(LPCMINVOKECOMMANDINFO lpcmi)
{

	HRESULT hr = E_INVALIDARG;
	DWORD dwThreadID=0;

    //If HIWORD(lpcmi->lpVerb) then we have been called programmatically
    //and lpVerb is a command that should be invoked.  Otherwise, the shell
    //has called us, and LOWORD(lpcmi->lpVerb) is the menu ID the user has
    //selected.  Actually, it's (menu ID - idCmdFirst) from QueryContextMenu().
	if (!HIWORD(lpcmi->lpVerb))
    {
        UINT idCmd = LOWORD(lpcmi->lpVerb);

        switch (idCmd)
        {
		case 0:
			{
				if(m_bEncryptMode)
				{
					if(MessageBox(NULL,"Encrypt this file now ?","ePass1000 Sample",MB_YESNO)==IDYES)
					{	
						/*g_hEventOk  = CreateEvent(NULL,FALSE,FALSE,NULL);
						HANDLE  hThread=CreateThread(NULL,0,EncryptTProc,m_pFileNames[0],0,&dwThreadID);
						WaitForSingleObject(g_hEventOk,INFINITE);*/
						EF_Encrypt(m_pFileNames[0]);
					}	
				}					
				else
				{
					if(MessageBox(NULL,"Decrypt this file now ?","ePass1000 Sample",MB_YESNO)==IDYES)
					{	
						/*g_hEventOk  = CreateEvent(NULL,FALSE,FALSE,NULL);
						HANDLE  hThread=CreateThread(NULL,0,DecryptTProc,m_pFileNames[0],0,&dwThreadID);						
						WaitForSingleObject(g_hEventOk,INFINITE);*/
						EF_Decrypt(m_pFileNames[0]);
					}	
				}					
			}
			break;
		default:
			break;
        }
    }
    return hr;
}


//
//  FUNCTION: CShellExt::InvokeCommand(LPCMINVOKECOMMANDINFO)
//
//  PURPOSE: Called by the shell after the user has selected on of the
//           menu items that was added in QueryContextMenu().
//
//  PARAMETERS:
//    lpcmi - Pointer to an CMINVOKECOMMANDINFO structure
//
//  RETURN VALUE:
//
//
//  COMMENTS:
//

STDMETHODIMP CShellExt::GetCommandString(UINT idCmd,
                                         UINT uFlags,
                                         UINT FAR *reserved,
                                         LPSTR pszName,
                                         UINT cchMax)
{
//    switch (idCmd)
//    {
//        case 0:
//            lstrcpy(pszName, "New menu item number 1");
//            break;
//
//        case 1:
//            lstrcpy(pszName, "New menu item number 2");
//            break;
//
//        case 2:
//            lstrcpy(pszName, "New menu item number 3");
//            break;
//
//        case 3:
//            lstrcpy(pszName, "New menu item number 4");
//            break;
//    }

    return NOERROR;
}

