
#include "stdafx.h"
#include "ShellExt.h"


//
//  FUNCTION: CShellExt::Initialize(LPCITEMIDLIST, LPDATAOBJECT, HKEY)
//
//  PURPOSE: Called by the shell when initializing a context menu or property
//           sheet extension.
//
//  PARAMETERS:
//    pIDFolder - Specifies the parent folder
//    pDataObj  - Spefifies the set of items selected in that folder.
//    hRegKey   - Specifies the type of the focused item in the selection.
//
//  RETURN VALUE:
//	
//    NOERROR in all cases.
//
//  COMMENTS:   Note that at the time this function is called, we don't know 
//              (or care) what type of shell extension is being initialized.  
//              It could be a context menu or a property sheet.
//

STDMETHODIMP CShellExt::Initialize(LPCITEMIDLIST pIDFolder,
                                   LPDATAOBJECT pDataObj,
                                   HKEY hRegKey)
{
	ODSTR("CShellExt::Initialize\n");
    // Initialize can be called more than once

    if (m_pDataObj)
    	m_pDataObj->Release();

	FreeVars();

    // duplicate the object pointer and registry handle

    if (pDataObj)
    {
    	m_pDataObj = pDataObj;
    	pDataObj->AddRef();

		STGMEDIUM stgMed;
		FORMATETC fmtEtc = { CF_HDROP,NULL,DVASPECT_CONTENT,-1,TYMED_HGLOBAL};

		HRESULT hr = pDataObj->GetData(&fmtEtc,&stgMed);
		if(FAILED(hr))
		{
			return E_FAIL;
		}
		char tmpPath[MAX_PATH];
		
		//Get count of selected file.
		m_nFileCount = DragQueryFile((HDROP)stgMed.hGlobal,0xFFFFFFFF,tmpPath,MAX_PATH);
		
		m_pFileNames = new PCHAR[m_nFileCount];
		//check if we allocate array success.
		if(m_pFileNames == NULL)
		{
			ReleaseStgMedium(&stgMed);
			return NOERROR;
		}
		//clear pointer array.
		for(int i=0;i<m_nFileCount;i++)
			m_pFileNames[i] = NULL;
		//get file name and save it.
		ODSTR("Begin dump selected file name\n\n");
		for(i=0;i<m_nFileCount;i++)
		{
			//allocate string buffer.
			char* tmpStr = new char[MAX_PATH];
			if(tmpStr == NULL)
				return NOERROR;
			
			m_pFileNames[i] =tmpStr;
			//get file name.
			DragQueryFile((HDROP)stgMed.hGlobal,i,tmpStr,MAX_PATH);

			ODSTR(m_pFileNames[i]);
			ODSTR("\n");
		}
		ODSTR("End dump selected file name\n\n");
		ReleaseStgMedium(&stgMed);

		m_bEncryptMode = !CheckFileExt(m_pFileNames[0],"!ef");
    }

    return NOERROR;
}
